/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.ColumnInfo;
import io.overcoded.grid.processor.ColumnInfoFactory;
import io.overcoded.grid.processor.FieldCollector;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnInfoCollector {
    private static final Logger log = LoggerFactory.getLogger(ColumnInfoCollector.class);
    private final Map<Class<?>, List<ColumnInfo>> typeCache = new ConcurrentHashMap();
    private final ColumnInfoFactory columnInfoFactory;
    private final FieldCollector fieldCollector;

    public List<ColumnInfo> collect(Class<?> type) {
        return this.typeCache.computeIfAbsent(type, this::collectColumnInfos);
    }

    private List<ColumnInfo> collectColumnInfos(Class<?> type) {
        log.debug("Collecting column infos for {}", (Object)type.getName());
        return this.fieldCollector.getFields(type).stream().map(field -> this.columnInfoFactory.create((Field)field, type)).filter(Objects::nonNull).sorted().collect(Collectors.toList());
    }

    public ColumnInfoCollector(ColumnInfoFactory columnInfoFactory, FieldCollector fieldCollector) {
        this.columnInfoFactory = columnInfoFactory;
        this.fieldCollector = fieldCollector;
    }
}

