/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.MenuEntry;
import io.overcoded.grid.annotation.GridView;
import io.overcoded.grid.processor.MenuEntryFactory;
import io.overcoded.grid.processor.ReflectionsFactory;
import io.overcoded.grid.processor.SubmenuEntryCollector;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuEntryCollector {
    private static final Logger log = LoggerFactory.getLogger(MenuEntryCollector.class);
    private final MenuEntryFactory menuEntryFactory;
    private final ReflectionsFactory reflectionsFactory;
    private final SubmenuEntryCollector submenuEntryCollector;

    public List<MenuEntry> collect(String basePackage, String pathPrefix) {
        log.debug("Collecting menu entries in {} for {}", (Object)basePackage, (Object)pathPrefix);
        Reflections reflections = this.reflectionsFactory.create(basePackage);
        List<MenuEntry> views = this.collectAllMenuEntries(pathPrefix, reflections);
        List<MenuEntry> submenuEntries = MenuEntryCollector.collectSubmenus(views);
        List<MenuEntry> result = views.stream().filter(Predicate.not(MenuEntry::isGrouped)).map(menuEntry -> this.extendWithSubmenus((MenuEntry)menuEntry, submenuEntries)).sorted().collect(Collectors.toList());
        log.trace("Collected menu entries: {}", result);
        return result;
    }

    private static List<MenuEntry> collectSubmenus(List<MenuEntry> views) {
        return views.stream().filter(MenuEntry::isGrouped).collect(Collectors.toList());
    }

    private List<MenuEntry> collectAllMenuEntries(String pathPrefix, Reflections reflections) {
        return reflections.getTypesAnnotatedWith(GridView.class).stream().map(type -> this.menuEntryFactory.create((Class<?>)type, pathPrefix)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private MenuEntry extendWithSubmenus(MenuEntry menuEntry, List<MenuEntry> submenuEntries) {
        menuEntry.setEntries(this.submenuEntryCollector.collect(menuEntry, submenuEntries));
        return menuEntry;
    }

    public MenuEntryCollector(MenuEntryFactory menuEntryFactory, ReflectionsFactory reflectionsFactory, SubmenuEntryCollector submenuEntryCollector) {
        this.menuEntryFactory = menuEntryFactory;
        this.reflectionsFactory = reflectionsFactory;
        this.submenuEntryCollector = submenuEntryCollector;
    }
}

