/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.ColumnInfo;
import io.overcoded.grid.ContextMenuGroup;
import io.overcoded.grid.GridInfo;
import io.overcoded.grid.MethodInfo;
import io.overcoded.grid.annotation.GridView;
import io.overcoded.grid.processor.ColumnInfoCollector;
import io.overcoded.grid.processor.ContextMenuGroupCollector;
import io.overcoded.grid.processor.GridInfoFactory;
import io.overcoded.grid.processor.MethodInfoFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridInfoViewFactory
implements GridInfoFactory<GridView> {
    private static final Logger log = LoggerFactory.getLogger(GridInfoViewFactory.class);
    private final Map<Class<?>, GridInfo> typeCache = new ConcurrentHashMap();
    private final MethodInfoFactory methodInfoFactory;
    private final ColumnInfoCollector columnInfoCollector;
    private final ContextMenuGroupCollector contextMenuGroupCollector;

    @Override
    public Class<GridView> getSourceType() {
        return GridView.class;
    }

    @Override
    public GridInfo create(Class<?> type) {
        if (!type.isAnnotationPresent(this.getSourceType())) {
            throw new IllegalArgumentException("GridView annotation must present on input type.");
        }
        return this.typeCache.computeIfAbsent(type, this::createGridInfo);
    }

    private GridInfo createGridInfo(Class<?> type) {
        log.debug("Creating grid info for {}", (Object)type.getName());
        GridView source = type.getAnnotation(this.getSourceType());
        List<ColumnInfo> columns = this.columnInfoCollector.collect(type);
        List<ContextMenuGroup> contextMenuGroups = this.contextMenuGroupCollector.collect(type);
        MethodInfo methodInfo = this.methodInfoFactory.create(type, columns);
        return GridInfo.builder().columns(columns).enabledMethods(List.of(source.enabledMethods())).enabledFor(List.of(source.enabledFor())).contextMenuGroups(contextMenuGroups).description(source.description()).sourceAnnotation(this.getSourceType()).methodInfo(methodInfo).type(type).build();
    }

    public GridInfoViewFactory(MethodInfoFactory methodInfoFactory, ColumnInfoCollector columnInfoCollector, ContextMenuGroupCollector contextMenuGroupCollector) {
        this.methodInfoFactory = methodInfoFactory;
        this.columnInfoCollector = columnInfoCollector;
        this.contextMenuGroupCollector = contextMenuGroupCollector;
    }
}

