/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.GridInfo;
import io.overcoded.grid.processor.GridInfoFactory;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class DynamicGridInfoFactory {
    private final List<GridInfoFactory<?>> factories;

    public GridInfo create(Class<?> type) {
        return Arrays.stream(type.getAnnotations()).map(this::getFactoryForAnnotation).filter(Objects::nonNull).findFirst().map(factory -> factory.create(type)).orElse(null);
    }

    private GridInfoFactory<?> getFactoryForAnnotation(Annotation annotation) {
        return this.factories.stream().filter(factory -> Objects.equals(factory.getSourceType(), annotation.annotationType())).findFirst().orElse(null);
    }

    public DynamicGridInfoFactory(List<GridInfoFactory<?>> factories) {
        this.factories = factories;
    }
}

