/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.ContextMenuGroup;
import io.overcoded.grid.annotation.GridDialog;
import io.overcoded.grid.processor.ContextMenuEntryFactory;
import io.overcoded.grid.processor.GridDialogValidator;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextMenuGroupFactory {
    private static final Logger log = LoggerFactory.getLogger(ContextMenuGroupFactory.class);
    private final ContextMenuEntryFactory contextMenuEntryFactory;
    private final GridDialogValidator gridDialogValidator;

    public ContextMenuGroup create(Field field, Class<?> parentType) {
        ContextMenuGroup columnInfo = null;
        if (Objects.nonNull(field) && this.gridDialogValidator.isDialogCandidate(field)) {
            log.debug("Creating dialog for {} in {}", (Object)field.getName(), (Object)parentType.getName());
            Class<?> genericType = this.getGenericType(field);
            if (genericType.isAnnotationPresent(GridDialog.class)) {
                GridDialog gridDialog = genericType.getAnnotation(GridDialog.class);
                columnInfo = ContextMenuGroup.builder().order(gridDialog.order()).icon(gridDialog.groupIcon()).label(gridDialog.menuGroup()).contextMenuEntries(List.of(this.contextMenuEntryFactory.create(field, genericType, parentType))).build();
            } else {
                log.warn("{} in {} is a valid candidate as a dialog, but GridDialog annotation is not present on its type.", (Object)field.getName(), (Object)parentType.getName());
            }
        } else {
            log.debug("Field {} in {} is not a valid dialog candidate", (Object)field.getName(), (Object)parentType.getName());
        }
        return columnInfo;
    }

    private Class<?> getGenericType(Field field) {
        Class result = field.getType();
        if (field.getType().isAssignableFrom(Collection.class) || field.getType().isAssignableFrom(Set.class) || field.getType().isAssignableFrom(List.class)) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            result = (Class)actualTypeArguments[0];
        }
        return result;
    }

    public ContextMenuGroupFactory(ContextMenuEntryFactory contextMenuEntryFactory, GridDialogValidator gridDialogValidator) {
        this.contextMenuEntryFactory = contextMenuEntryFactory;
        this.gridDialogValidator = gridDialogValidator;
    }
}

