/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.ContextMenuEntry;
import io.overcoded.grid.annotation.GridDialog;
import io.overcoded.grid.processor.column.NameTransformer;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextMenuEntryFactory {
    private static final Logger log = LoggerFactory.getLogger(ContextMenuEntryFactory.class);
    private final NameTransformer nameTransformer;

    public ContextMenuEntry create(Field field, Class<?> genericType, Class<?> parentType) {
        ContextMenuEntry columnInfo = null;
        log.debug("Creating context menu entry for {} in {}", (Object)field.getName(), (Object)parentType.getName());
        if (genericType.isAnnotationPresent(GridDialog.class)) {
            GridDialog gridDialog = genericType.getAnnotation(GridDialog.class);
            columnInfo = ContextMenuEntry.builder().type(genericType).parentType(parentType).icon(gridDialog.icon()).order(gridDialog.order()).description(gridDialog.description()).label(this.nameTransformer.transform(field)).enabledFor(Arrays.asList(gridDialog.enabledFor())).build();
        }
        return columnInfo;
    }

    public ContextMenuEntryFactory(NameTransformer nameTransformer) {
        this.nameTransformer = nameTransformer;
    }
}

