/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.ColumnInfo;
import io.overcoded.grid.annotation.GridColumn;
import io.overcoded.grid.processor.GridDialogValidator;
import io.overcoded.grid.processor.column.DisplayValueExpressionExtractor;
import io.overcoded.grid.processor.column.FieldProviderTypeDecider;
import io.overcoded.grid.processor.column.NameTransformer;
import java.lang.reflect.Field;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnInfoFactory {
    private static final Logger log = LoggerFactory.getLogger(ColumnInfoFactory.class);
    private final FieldProviderTypeDecider fieldProviderTypeDecider;
    private final DisplayValueExpressionExtractor displayValueExpressionExtractor;
    private final GridDialogValidator gridDialogValidator;
    private final NameTransformer nameTransformer;

    public ColumnInfo create(Field field, Class<?> parentType) {
        log.debug("Creating column info for {} in {}", (Object)field.getName(), (Object)parentType.getName());
        ColumnInfo columnInfo = null;
        if (!this.gridDialogValidator.isDialogCandidate(field)) {
            Optional<GridColumn> gridColumn = Optional.ofNullable(field.getAnnotation(GridColumn.class));
            columnInfo = ColumnInfo.builder().type(field.getType()).name(field.getName()).parentType(parentType).label(this.nameTransformer.transform(field)).fieldProviderType(this.fieldProviderTypeDecider.decide(field, gridColumn.orElse(null))).hidden(gridColumn.map(GridColumn::hidden).orElse(true)).filter(gridColumn.map(GridColumn::filter).orElse(false)).order(gridColumn.map(GridColumn::order).orElse(Integer.MAX_VALUE)).placeholder(gridColumn.map(GridColumn::placeholder).orElse(null)).displayValueExpressionParts(this.displayValueExpressionExtractor.extract(field)).build();
        }
        return columnInfo;
    }

    public ColumnInfoFactory(FieldProviderTypeDecider fieldProviderTypeDecider, DisplayValueExpressionExtractor displayValueExpressionExtractor, GridDialogValidator gridDialogValidator, NameTransformer nameTransformer) {
        this.fieldProviderTypeDecider = fieldProviderTypeDecider;
        this.displayValueExpressionExtractor = displayValueExpressionExtractor;
        this.gridDialogValidator = gridDialogValidator;
        this.nameTransformer = nameTransformer;
    }
}

