/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.repository.annotation.processor.supplier;

import io.overcoded.repository.annotation.Projected;
import io.overcoded.repository.annotation.processor.config.RepositoryProperties;
import io.overcoded.repository.annotation.processor.domain.ElementCollection;
import io.overcoded.repository.annotation.processor.domain.MethodData;
import io.overcoded.repository.annotation.processor.domain.RepositoryData;
import io.overcoded.repository.annotation.processor.supplier.AbstractSupplier;
import io.overcoded.repository.annotation.processor.supplier.Supplier;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;

class ProjectionSupplier
extends AbstractSupplier
implements Supplier {
    private static final String PROJECTION_NORMAL_GETTER_PREFIX = "get";
    private static final String PROJECTION_BOOLEAN_GETTER_PREFIX = "is";

    public ProjectionSupplier(RepositoryProperties repositoryConfiguration) {
        super(repositoryConfiguration);
    }

    @Override
    public RepositoryData execute(ElementCollection elementCollection, RepositoryData repositoryData) {
        if (Objects.nonNull(elementCollection.getProjectedElements()) && !elementCollection.getProjectedElements().isEmpty()) {
            elementCollection.getProjectedElements().forEach(projectionElement -> this.addProjectionAnnotation(repositoryData, (Element)projectionElement));
        }
        return super.execute(elementCollection, repositoryData);
    }

    private void addProjectionAnnotation(RepositoryData repositoryData, Element projectedElement) {
        repositoryData.getProjectedFields().add(this.createMethodData(projectedElement));
    }

    private MethodData createMethodData(Element projectedElement) {
        boolean isBooleanMethod = projectedElement.asType().getKind() == TypeKind.BOOLEAN && projectedElement.asType().getKind().isPrimitive();
        String prefix = isBooleanMethod ? PROJECTION_BOOLEAN_GETTER_PREFIX : PROJECTION_NORMAL_GETTER_PREFIX;
        return MethodData.builder().methodName(this.createMethod(prefix, projectedElement)).parameters(projectedElement.asType().toString()).build();
    }

    private String createMethod(String prefix, Element projectedElement) {
        String elementName = projectedElement.getSimpleName().toString();
        Projected projected = projectedElement.getAnnotation(Projected.class);
        return prefix + elementName.substring(0, 1).toUpperCase() + elementName.substring(1);
    }
}

