/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.repository.annotation.processor.supplier;

import io.overcoded.repository.annotation.FindOne;
import io.overcoded.repository.annotation.FindOneArray;
import io.overcoded.repository.annotation.processor.config.RepositoryProperties;
import io.overcoded.repository.annotation.processor.domain.ElementCollection;
import io.overcoded.repository.annotation.processor.domain.MethodData;
import io.overcoded.repository.annotation.processor.domain.RepositoryData;
import io.overcoded.repository.annotation.processor.supplier.AbstractSupplier;
import io.overcoded.repository.annotation.processor.supplier.Supplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;

class FindOneSupplier
extends AbstractSupplier
implements Supplier {
    public static final String PARAMETER_SEPARATOR = ",";
    private static final String METHOD_PARAMETER_SUFFIX = " arg";

    public FindOneSupplier(RepositoryProperties repositoryConfiguration) {
        super(repositoryConfiguration);
    }

    @Override
    public RepositoryData execute(ElementCollection elementCollection, RepositoryData repositoryData) {
        List<Element> findOneArrayElements = elementCollection.getFindOneArrayElements();
        if (Objects.nonNull(findOneArrayElements) && !findOneArrayElements.isEmpty()) {
            findOneArrayElements.forEach(findAllElement -> this.extractFindOneAnnotation(repositoryData, (Element)findAllElement));
        }
        return super.execute(elementCollection, repositoryData);
    }

    private void extractFindOneAnnotation(RepositoryData repositoryData, Element findOneElement) {
        FindOne findOne;
        FindOneArray findOneArray = findOneElement.getAnnotation(FindOneArray.class);
        if (Objects.nonNull(findOneArray) && findOneArray.value().length != 0) {
            Arrays.asList(findOneArray.value()).forEach(findAll -> this.createMethod(repositoryData, (FindOne)findAll));
        }
        if (Objects.nonNull(findOne = findOneElement.getAnnotation(FindOne.class))) {
            this.createMethod(repositoryData, findOne);
        }
    }

    private void createMethod(RepositoryData repositoryData, FindOne findOne) {
        String parameters = this.createParameters(findOne);
        String findOneMethod = this.getFindOneMethod(findOne);
        if (Objects.nonNull(findOneMethod) && findOneMethod.startsWith("find")) {
            findOneMethod = findOneMethod.substring(4);
        }
        repositoryData.getFindOneMethods().add(MethodData.builder().methodName(findOneMethod).parameters(parameters).build());
    }

    private String createParameters(FindOne findOne) {
        List<String> parameterTypes = this.getParameterTypes(findOne);
        StringBuilder parameters = new StringBuilder();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            parameters.append(parameterTypes.get(i)).append(METHOD_PARAMETER_SUFFIX).append(i);
            if (i == parameterTypes.size() - 1) continue;
            parameters.append(PARAMETER_SEPARATOR);
        }
        return parameters.toString();
    }

    private String getFindOneMethod(FindOne findOne) {
        String method;
        try {
            method = findOne.method();
        }
        catch (MirroredTypeException e) {
            TypeMirror typeMirror = e.getTypeMirror();
            method = typeMirror.toString();
        }
        return method;
    }

    private List<String> getParameterTypes(FindOne findOne) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Arrays.asList(findOne.types()).forEach(type -> result.add(type.getName()));
        }
        catch (MirroredTypesException e) {
            List<? extends TypeMirror> typeMirrors = e.getTypeMirrors();
            typeMirrors.forEach(typeMirror -> result.add(typeMirror.toString()));
        }
        return result;
    }
}

