/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.repository.annotation.processor.supplier;

import io.overcoded.repository.annotation.DynamicRepository;
import io.overcoded.repository.annotation.processor.config.RepositoryProperties;
import io.overcoded.repository.annotation.processor.domain.ElementCollection;
import io.overcoded.repository.annotation.processor.domain.MethodData;
import io.overcoded.repository.annotation.processor.domain.RepositoryData;
import io.overcoded.repository.annotation.processor.supplier.AbstractSupplier;
import io.overcoded.repository.annotation.processor.supplier.Supplier;
import java.util.HashSet;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynamicRepositorySupplier
extends AbstractSupplier
implements Supplier {
    private static final Logger log = LoggerFactory.getLogger(DynamicRepositorySupplier.class);

    public DynamicRepositorySupplier(RepositoryProperties repositoryConfiguration) {
        super(repositoryConfiguration);
    }

    @Override
    public RepositoryData execute(ElementCollection elementCollection, RepositoryData repositoryData) {
        repositoryData.setFindMethods(new HashSet<MethodData>());
        repositoryData.setCountMethods(new HashSet<MethodData>());
        repositoryData.setFindOneMethods(new HashSet<MethodData>());
        repositoryData.setProjectedFields(new HashSet<MethodData>());
        repositoryData.setSuffix(this.getSuffix(elementCollection));
        repositoryData.setResourcePath(this.getResourcePath(elementCollection));
        repositoryData.setRestResourceEnabled(this.isRestResourceEnabled(elementCollection));
        repositoryData.setFetchSize(this.getFetchSize(elementCollection));
        repositoryData.setEntityType(elementCollection.getDynamicRepositoryElement().getSimpleName().toString());
        repositoryData.setPackageName(elementCollection.getDynamicRepositoryElement().getEnclosingElement().toString());
        return super.execute(elementCollection, repositoryData);
    }

    private boolean isRestResourceEnabled(ElementCollection elementCollection) {
        boolean restResourceEnabled = elementCollection.getDynamicRepositoryElement().getAnnotation(DynamicRepository.class).restResourceEnabled();
        if (!restResourceEnabled) {
            restResourceEnabled = Boolean.parseBoolean(this.repositoryConfiguration.getRestResourceEnabled());
        }
        return restResourceEnabled;
    }

    private String getResourcePath(ElementCollection elementCollection) {
        String resourcePath = elementCollection.getDynamicRepositoryElement().getAnnotation(DynamicRepository.class).resourcePath();
        return this.getStringProperty(resourcePath, this.repositoryConfiguration.getResourcePath());
    }

    private String getSuffix(ElementCollection elementCollection) {
        String suffix = elementCollection.getDynamicRepositoryElement().getAnnotation(DynamicRepository.class).suffix();
        return this.getStringProperty(suffix, this.repositoryConfiguration.getSuffix());
    }

    private String getFetchSize(ElementCollection elementCollection) {
        String fetchSize = elementCollection.getDynamicRepositoryElement().getAnnotation(DynamicRepository.class).streamFetchSize();
        return this.getStringProperty(fetchSize, this.repositoryConfiguration.getStreamFetchSize());
    }

    private String getStringProperty(String annotationValue, String commonValue) {
        if (Objects.isNull(annotationValue) || annotationValue.isBlank()) {
            annotationValue = commonValue;
        }
        return annotationValue;
    }
}

