/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.repository.annotation.processor.supplier;

import io.overcoded.repository.annotation.processor.config.RepositoryProperties;
import io.overcoded.repository.annotation.processor.domain.ElementCollection;
import io.overcoded.repository.annotation.processor.domain.RepositoryData;
import io.overcoded.repository.annotation.processor.supplier.Supplier;
import java.util.Objects;

abstract class AbstractSupplier
implements Supplier {
    private Supplier next;
    protected RepositoryProperties repositoryConfiguration;

    public AbstractSupplier(RepositoryProperties repositoryConfiguration) {
        this.repositoryConfiguration = repositoryConfiguration;
    }

    @Override
    public Supplier getLast() {
        Supplier last = this;
        while (Objects.nonNull(last.getNext())) {
            last = last.getNext();
        }
        return last;
    }

    @Override
    public RepositoryData execute(ElementCollection elementCollection, RepositoryData repositoryData) {
        return Objects.nonNull(this.getNext()) ? this.getNext().execute(elementCollection, repositoryData) : repositoryData;
    }

    @Override
    public Supplier getNext() {
        return this.next;
    }

    public RepositoryProperties getRepositoryConfiguration() {
        return this.repositoryConfiguration;
    }

    @Override
    public void setNext(Supplier next) {
        this.next = next;
    }

    public void setRepositoryConfiguration(RepositoryProperties repositoryConfiguration) {
        this.repositoryConfiguration = repositoryConfiguration;
    }
}

