/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.repository.annotation.processor.generator;

import io.overcoded.repository.annotation.processor.domain.RepositoryData;
import io.overcoded.repository.annotation.processor.generator.ProjectionGenerator;
import io.overcoded.repository.annotation.processor.generator.RepositoryGenerator;
import io.overcoded.repository.annotation.processor.generator.SourceCodeGenerator;
import io.overcoded.repository.annotation.processor.generator.SourceFile;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

public class SourceCodeWriter {
    private final List<SourceCodeGenerator> generators = List.of(new RepositoryGenerator(), new ProjectionGenerator());

    public void generate(RepositoryData repositoryData, Filer filer) {
        this.generators.stream().map(generator -> generator.generate(repositoryData.toBuilder().build())).filter(Objects::nonNull).forEach(sourceFile -> this.writeJavaFile((SourceFile)sourceFile, filer));
    }

    private void writeJavaFile(SourceFile sourceFile, Filer filer) {
        try {
            JavaFileObject builderFile = filer.createSourceFile(sourceFile.getFilename(), new Element[0]);
            try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
                out.println(sourceFile.getContent());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

