/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.repository.annotation.processor.generator;

import io.overcoded.repository.annotation.processor.domain.MethodData;
import io.overcoded.repository.annotation.processor.domain.RepositoryData;
import io.overcoded.repository.annotation.processor.generator.SourceCodeGenerator;
import io.overcoded.repository.annotation.processor.generator.SourceFile;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class RepositoryGenerator
implements SourceCodeGenerator {
    private static final String REPOSITORY_TEMPLATE_FILE = "templates/repository_template.vm";
    private static final String COUNT_METHOD_TEMPLATE_FILE = "templates/count_method_template.vm";
    private static final String FIND_METHOD_TEMPLATE_FILE = "templates/find_method_template.vm";
    private static final String FIND_ONE_METHOD_TEMPLATE_FILE = "templates/find_one_method_template.vm";
    private static final String ENTITY_TYPE_TEMPLATE_VARIABLE = "entityType";
    private static final String REST_RESOURCE_ENABLED = "restResourceEnabled";
    private static final String REST_RESOURCE_PATH = "restResourcePath";
    private static final String FETCH_SIZE_TEMPLATE_VARIABLE = "fetchSize";
    private static final String PACKAGE_NAME_TEMPLATE_VARIABLE = "packageName";
    private static final String SIMPLE_CLASS_NAME_TEMPLATE_VARIABLE = "simpleClassName";
    private static final String METHODS_TEMPLATE_VARIABLE = "methods";
    private static final String METHOD_NAME_TEMPLATE_VARIABLE = "methodName";
    private static final String PARAMETERS_TEMPLATE_VARIABLE = "parameters";
    private static final String REPOSITORY_CLASS_SUFFIX = "JpaRepository";
    private static final String PACKAGE_SEPARATOR = ".";

    @Override
    public SourceFile generate(RepositoryData repositoryData) {
        String suffix = this.getSafeSuffix(repositoryData);
        String simpleClassName = repositoryData.getEntityType() + suffix;
        String builderClassName = repositoryData.getPackageName() + PACKAGE_SEPARATOR + simpleClassName;
        repositoryData.setSimpleClassName(simpleClassName);
        return SourceFile.builder().filename(builderClassName).content(this.generateContent(repositoryData)).build();
    }

    private String generateContent(RepositoryData repositoryData) {
        VelocityEngine velocityEngine = this.createEngine();
        Template template = velocityEngine.getTemplate(REPOSITORY_TEMPLATE_FILE);
        VelocityContext context = this.createContextForRepository(repositoryData, velocityEngine);
        StringWriter writer = new StringWriter();
        template.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    private String generateMethods(VelocityEngine velocityEngine, RepositoryData repositoryData) {
        StringWriter writer = new StringWriter();
        this.createFindOneMethods(velocityEngine, repositoryData, writer);
        this.createFindMethods(velocityEngine, repositoryData, writer);
        this.createCountMethods(velocityEngine, repositoryData, writer);
        return writer.toString();
    }

    private void createFindOneMethods(VelocityEngine velocityEngine, RepositoryData repositoryData, StringWriter writer) {
        repositoryData.getFindOneMethods().forEach(methodData -> this.createMethod(velocityEngine, repositoryData, writer, (MethodData)methodData, FIND_ONE_METHOD_TEMPLATE_FILE));
    }

    private void createFindMethods(VelocityEngine velocityEngine, RepositoryData repositoryData, StringWriter writer) {
        repositoryData.getFindMethods().forEach(methodData -> this.createMethod(velocityEngine, repositoryData, writer, (MethodData)methodData, FIND_METHOD_TEMPLATE_FILE));
    }

    private void createCountMethods(VelocityEngine velocityEngine, RepositoryData repositoryData, StringWriter writer) {
        repositoryData.getCountMethods().forEach(methodData -> this.createMethod(velocityEngine, repositoryData, writer, (MethodData)methodData, COUNT_METHOD_TEMPLATE_FILE));
    }

    private void createMethod(VelocityEngine velocityEngine, RepositoryData repositoryData, StringWriter writer, MethodData methodData, String findMethodTemplateFile) {
        Template template = velocityEngine.getTemplate(findMethodTemplateFile);
        VelocityContext context = this.createContextForMethod(repositoryData, methodData);
        template.merge((Context)context, (Writer)writer);
    }

    private VelocityEngine createEngine() {
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.setProperty("resource.loaders", (Object)"classpath");
        velocityEngine.setProperty("resource.loader.classpath.class", (Object)ClasspathResourceLoader.class.getName());
        velocityEngine.init();
        return velocityEngine;
    }

    private VelocityContext createContextForRepository(RepositoryData repositoryData, VelocityEngine velocityEngine) {
        VelocityContext context = new VelocityContext();
        context.put(REST_RESOURCE_ENABLED, (Object)repositoryData.isRestResourceEnabled());
        context.put(REST_RESOURCE_PATH, (Object)repositoryData.getResourcePath());
        context.put(ENTITY_TYPE_TEMPLATE_VARIABLE, (Object)repositoryData.getEntityType());
        context.put(FETCH_SIZE_TEMPLATE_VARIABLE, (Object)repositoryData.getFetchSize());
        context.put(PACKAGE_NAME_TEMPLATE_VARIABLE, (Object)repositoryData.getPackageName());
        context.put(SIMPLE_CLASS_NAME_TEMPLATE_VARIABLE, (Object)repositoryData.getSimpleClassName());
        context.put(METHODS_TEMPLATE_VARIABLE, (Object)this.generateMethods(velocityEngine, repositoryData));
        return context;
    }

    private VelocityContext createContextForMethod(RepositoryData repositoryData, MethodData methodData) {
        VelocityContext context = new VelocityContext();
        context.put(REST_RESOURCE_ENABLED, (Object)repositoryData.isRestResourceEnabled());
        context.put(ENTITY_TYPE_TEMPLATE_VARIABLE, (Object)repositoryData.getEntityType());
        context.put(FETCH_SIZE_TEMPLATE_VARIABLE, (Object)repositoryData.getFetchSize());
        context.put(METHOD_NAME_TEMPLATE_VARIABLE, (Object)methodData.getMethodName());
        context.put(PARAMETERS_TEMPLATE_VARIABLE, (Object)methodData.getParameters());
        return context;
    }

    private String getSafeSuffix(RepositoryData repositoryData) {
        return Objects.nonNull(repositoryData.getSuffix()) && !repositoryData.getSuffix().isBlank() ? repositoryData.getSuffix().trim() : REPOSITORY_CLASS_SUFFIX;
    }
}

