/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.repository.annotation.processor.config;

import io.overcoded.repository.annotation.processor.config.RepositoryProperties;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryPropertiesReader {
    private static final Logger log = LoggerFactory.getLogger(RepositoryPropertiesReader.class);
    private static final String REPOSITORY_PROPERTIES = "repository.properties";
    private static final String SETTER_PREFIX = "set";

    public static RepositoryProperties read() {
        RepositoryProperties repositoryProperties = new RepositoryProperties();
        Properties properties = RepositoryPropertiesReader.readProperties();
        properties.stringPropertyNames().forEach(property -> RepositoryPropertiesReader.getSetterMethod(property).ifPresent(method -> RepositoryPropertiesReader.invokeMethod(repositoryProperties, properties, property, method)));
        return repositoryProperties;
    }

    private static void invokeMethod(RepositoryProperties repositoryProperties, Properties properties, String property, Method method) {
        Object value = properties.get(property);
        try {
            method.invoke((Object)repositoryProperties, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Failed to set {} to {}", (Object)property, value);
        }
    }

    private static Properties readProperties() {
        Properties properties = new Properties();
        try {
            properties.load(RepositoryPropertiesReader.class.getClassLoader().getResourceAsStream(REPOSITORY_PROPERTIES));
        }
        catch (Exception e) {
            log.warn("Failed to load repository.properties");
        }
        return properties;
    }

    private static Optional<Method> getSetterMethod(String property) {
        Optional<Method> method = Optional.empty();
        try {
            String setterMethodName = RepositoryPropertiesReader.getSetterMethodName(property);
            method = Arrays.stream(RepositoryProperties.class.getDeclaredMethods()).filter(m -> setterMethodName.equalsIgnoreCase(m.getName())).findFirst();
        }
        catch (Exception ex) {
            log.error("Failed to found setter method for {}", (Object)property);
        }
        return method;
    }

    private static String getSetterMethodName(String property) {
        return SETTER_PREFIX + property;
    }
}

