/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.repository.annotation.processor.generator;

import io.overcoded.repository.annotation.processor.domain.RepositoryData;
import io.overcoded.repository.annotation.processor.generator.SourceCodeGenerator;
import io.overcoded.repository.annotation.processor.generator.SourceFile;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class ProjectionGenerator
implements SourceCodeGenerator {
    private static final String PROJECTION_TEMPLATE_FILE = "templates/projection_template.vm";
    private static final String ENTITY_TYPE_TEMPLATE_VARIABLE = "entityType";
    private static final String REST_RESOURCE_ENABLED = "restResourceEnabled";
    private static final String REST_RESOURCE_PATH = "restResourcePath";
    private static final String PACKAGE_NAME_TEMPLATE_VARIABLE = "packageName";
    private static final String SIMPLE_CLASS_NAME_TEMPLATE_VARIABLE = "simpleClassName";
    private static final String METHODS_TEMPLATE_VARIABLE = "methods";
    private static final String PACKAGE_SEPARATOR = ".";
    private static final String PROJECTION_SUFFIX = "Projection";

    @Override
    public SourceFile generate(RepositoryData repositoryData) {
        String simpleClassName = repositoryData.getEntityType() + PROJECTION_SUFFIX;
        String builderClassName = repositoryData.getPackageName() + PACKAGE_SEPARATOR + simpleClassName;
        repositoryData.setSimpleClassName(simpleClassName);
        return SourceFile.builder().filename(builderClassName).content(this.generateContent(repositoryData)).build();
    }

    private String generateContent(RepositoryData repositoryData) {
        VelocityEngine velocityEngine = this.createEngine();
        Template template = velocityEngine.getTemplate(PROJECTION_TEMPLATE_FILE);
        VelocityContext context = this.createContextForRepository(repositoryData);
        StringWriter writer = new StringWriter();
        template.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    private VelocityEngine createEngine() {
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.setProperty("resource.loader", (Object)"classpath");
        velocityEngine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        velocityEngine.init();
        return velocityEngine;
    }

    private VelocityContext createContextForRepository(RepositoryData repositoryData) {
        VelocityContext context = new VelocityContext();
        context.put(REST_RESOURCE_ENABLED, (Object)repositoryData.isRestResourceEnabled());
        context.put(REST_RESOURCE_PATH, (Object)repositoryData.getResourcePath());
        context.put(ENTITY_TYPE_TEMPLATE_VARIABLE, (Object)repositoryData.getEntityType());
        context.put(PACKAGE_NAME_TEMPLATE_VARIABLE, (Object)repositoryData.getPackageName());
        context.put(SIMPLE_CLASS_NAME_TEMPLATE_VARIABLE, (Object)repositoryData.getSimpleClassName());
        context.put(METHODS_TEMPLATE_VARIABLE, repositoryData.getProjectedFields());
        return context;
    }
}

