/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.repository.annotation.processor;

import com.google.auto.service.AutoService;
import io.overcoded.repository.annotation.processor.collector.ElementCollector;
import io.overcoded.repository.annotation.processor.collector.ElementCollectorFactory;
import io.overcoded.repository.annotation.processor.domain.ElementCollection;
import io.overcoded.repository.annotation.processor.domain.RepositoryData;
import io.overcoded.repository.annotation.processor.generator.SourceCodeWriter;
import io.overcoded.repository.annotation.processor.supplier.SupplierManager;
import io.overcoded.repository.annotation.processor.supplier.SupplierManagerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
@SupportedAnnotationTypes(value={"io.overcoded.repository.annotation.FindAll", "io.overcoded.repository.annotation.FindAllBy", "io.overcoded.repository.annotation.FindAllArray", "io.overcoded.repository.annotation.FindOneBy", "io.overcoded.repository.annotation.Projected", "io.overcoded.repository.annotation.DynamicRepository"})
@AutoService(value={Processor.class})
public class DynamicRepositoryProcessor
extends AbstractProcessor {
    private static final Logger log = LoggerFactory.getLogger(DynamicRepositoryProcessor.class);
    private final SupplierManager supplierManager;
    private final SourceCodeWriter sourceCodeWriter;
    private final Map<String, ElementCollector> fillers;

    public DynamicRepositoryProcessor() {
        this(SupplierManagerFactory.createDefaultManager(), new SourceCodeWriter(), ElementCollectorFactory.createElementCollectorMap());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Map<String, ElementCollection> elementCollectionMap = this.getElementCollectionMap(annotations, roundEnv);
        this.evaluateElementCollectionMap(elementCollectionMap);
        return false;
    }

    private Map<String, ElementCollection> getElementCollectionMap(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        HashMap<String, ElementCollection> elementCollectionMap = new HashMap<String, ElementCollection>();
        for (TypeElement typeElement : annotations) {
            String annotationName = typeElement.getSimpleName().toString();
            if (!this.fillers.containsKey(annotationName)) continue;
            this.fillers.get(annotationName).accept(elementCollectionMap, roundEnv.getElementsAnnotatedWith(typeElement));
        }
        return elementCollectionMap;
    }

    private void evaluateElementCollectionMap(Map<String, ElementCollection> elementCollectionMap) {
        elementCollectionMap.forEach((entityType, elementCollection) -> {
            if (Objects.nonNull(elementCollection.getDynamicRepositoryElement())) {
                RepositoryData repositoryData = this.supplierManager.requestSupply((ElementCollection)elementCollection, new RepositoryData());
                this.sourceCodeWriter.generate(repositoryData, this.processingEnv.getFiler());
            }
        });
    }

    public DynamicRepositoryProcessor(SupplierManager supplierManager, SourceCodeWriter sourceCodeWriter, Map<String, ElementCollector> fillers) {
        this.supplierManager = supplierManager;
        this.sourceCodeWriter = sourceCodeWriter;
        this.fillers = fillers;
    }
}

