/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.repository.annotation.processor.supplier;

import io.overcoded.repository.annotation.Projection;
import io.overcoded.repository.annotation.processor.domain.ElementCollection;
import io.overcoded.repository.annotation.processor.domain.MethodData;
import io.overcoded.repository.annotation.processor.domain.RepositoryData;
import io.overcoded.repository.annotation.processor.supplier.AbstractSupplier;
import io.overcoded.repository.annotation.processor.supplier.Supplier;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;

class ProjectionSupplier
extends AbstractSupplier
implements Supplier {
    private static final String PROJECTION_NORMAL_GETTER_PREFIX = "get";
    private static final String PROJECTION_BOOLEAN_GETTER_PREFIX = "is";

    ProjectionSupplier() {
    }

    @Override
    public RepositoryData execute(ElementCollection elementCollection, RepositoryData repositoryData) {
        if (Objects.nonNull(elementCollection.getProjectionElements()) && !elementCollection.getProjectionElements().isEmpty()) {
            elementCollection.getProjectionElements().forEach(projectionElement -> this.addProjectionAnnotation(repositoryData, (Element)projectionElement));
        }
        return super.execute(elementCollection, repositoryData);
    }

    private void addProjectionAnnotation(RepositoryData repositoryData, Element projectionElement) {
        repositoryData.getProjectionMethods().add(this.createMethodData(projectionElement));
    }

    private MethodData createMethodData(Element projectionElement) {
        boolean isBooleanMethod = projectionElement.asType().getKind() == TypeKind.BOOLEAN && projectionElement.asType().getKind().isPrimitive();
        String prefix = isBooleanMethod ? PROJECTION_BOOLEAN_GETTER_PREFIX : PROJECTION_NORMAL_GETTER_PREFIX;
        return MethodData.builder().methodName(this.createMethod(prefix, projectionElement)).parameters(projectionElement.asType().toString()).build();
    }

    private String createMethod(String prefix, Element projectionElement) {
        String elementName = projectionElement.getSimpleName().toString();
        Projection projection = projectionElement.getAnnotation(Projection.class);
        String modifier = Objects.nonNull(projection) ? projection.modifier() : "";
        return prefix + elementName.substring(0, 1).toUpperCase() + elementName.substring(1) + modifier;
    }
}

