package io.overcoded.repository.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * The outcome is a generated public JpaRepository in the same package with the domain class compile time.
 * Only with @Entity annotated classes.
 *
 * @author Diana Ladanyi
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.SOURCE)
public @interface DynamicRepository {
    /**
     * defines suffix of repository interface.
     * default is JpaRepository.
     *
     * @return string
     */
    String suffix() default "JpaRepository";

    /**
     * If you want to expose jpa repositories as rest endpoints,enable this option.
     *
     * Spring Boot default expose jpa repositories if spring data rest is on classpath.
     * For now, we can't detect the classpath, so you have to enable/disable manually.
     *
     * False means we won't generate spring data rest related entities into the source
     * code of the generated repository.
     * @return
     */
    boolean restResourceEnabled() default true;

    /**
     * if you want to rename the endpoint, just change this
     * @return ""
     */
    String resourcePath() default "";
}
