package io.overcoded.repository.annotation.processor.collector;

import io.overcoded.repository.annotation.processor.domain.ElementCollection;

import javax.lang.model.element.Element;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

/**
 * @author Diana Ladanyi
 * @author Adam Belak
 */
public class FindAllElementCollector implements ElementCollector {
    @Override
    public void accept(Map<String, ElementCollection> elementCollectionMap, Set<? extends Element> elements) {
        elements.forEach(element -> {
            String key = element.getSimpleName().toString();
            if (!elementCollectionMap.containsKey(key)) {
                elementCollectionMap.put(key, ElementCollection.builder().findAllByElements(new ArrayList<>()).findAllArrayElements(new ArrayList<>()).build());
            }
            elementCollectionMap.get(key).getFindAllArrayElements().add(element);
        });
    }
}
