package io.overcoded.repository.annotation.processor.collector;

import io.overcoded.repository.annotation.processor.domain.ElementCollection;
import lombok.extern.slf4j.Slf4j;

import javax.lang.model.element.Element;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

/**
 * @author Diana Ladanyi
 * @author Adam Belak
 */
@Slf4j
public class FindAllByElementCollector implements ElementCollector {
    @Override
    public void accept(Map<String, ElementCollection> elementCollectionMap, Set<? extends Element> elements) {
        log.trace("Trying to process elements: {}", elements);
        elements.forEach(element -> {
            String key = element.getEnclosingElement().getSimpleName().toString();
            log.debug("Processing {}", key);
            if (!elementCollectionMap.containsKey(key)) {
                elementCollectionMap.put(key, ElementCollection.builder().findAllArrayElements(new ArrayList<>()).findAllByElements(new ArrayList<>()).build());
            }
            elementCollectionMap.get(key).getFindAllByElements().add(element);
        });
    }
}
