package io.overcoded.repository.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * The outcome is a generated public JpaRepository in the same package with the domain class compile time.
 * Only with @Entity annotated classes.
 *
 * @author Diana Ladanyi
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.SOURCE)
public @interface DynamicRepository {
    /**
     * defines suffix of repository interface.
     * default is JpaRepository.
     *
     * @return string
     */
    String suffix() default "JpaRepository";
}
