/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.repository.annotation.processor;

import com.google.auto.service.AutoService;
import io.overcoded.repository.annotation.processor.RepositoryGenerator;
import io.overcoded.repository.annotation.processor.collector.ElementCollector;
import io.overcoded.repository.annotation.processor.collector.ElementCollectorFactory;
import io.overcoded.repository.annotation.processor.domain.ElementCollection;
import io.overcoded.repository.annotation.processor.domain.RepositoryData;
import io.overcoded.repository.annotation.processor.supplier.SupplierManager;
import io.overcoded.repository.annotation.processor.supplier.SupplierManagerFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
@SupportedAnnotationTypes(value={"io.overcoded.repository.annotation.FindAll", "io.overcoded.repository.annotation.FindAllBy", "io.overcoded.repository.annotation.FindAllArray", "io.overcoded.repository.annotation.DynamicRepository"})
@AutoService(value={Processor.class})
public class DynamicRepositoryProcessor
extends AbstractProcessor {
    private static final Logger log = LoggerFactory.getLogger(DynamicRepositoryProcessor.class);
    private static final String REPOSITORY_CLASS_SUFFIX = "JpaRepository";
    private static final String PACKAGE_SEPARATOR = ".";
    private final SupplierManager supplierManager;
    private final RepositoryGenerator repositoryGenerator;
    private final Map<String, ElementCollector> fillers;

    public DynamicRepositoryProcessor() {
        this(SupplierManagerFactory.createDefaultManager(), new RepositoryGenerator(), ElementCollectorFactory.createElementCollectorMap());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Map<String, ElementCollection> elementCollectionMap = this.getElementCollectionMap(annotations, roundEnv);
        this.evaluateElementCollectionMap(elementCollectionMap);
        return false;
    }

    private Map<String, ElementCollection> getElementCollectionMap(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        HashMap<String, ElementCollection> elementCollectionMap = new HashMap<String, ElementCollection>();
        for (TypeElement typeElement : annotations) {
            String annotationName = typeElement.getSimpleName().toString();
            if (!this.fillers.containsKey(annotationName)) continue;
            this.fillers.get(annotationName).accept(elementCollectionMap, roundEnv.getElementsAnnotatedWith(typeElement));
        }
        return elementCollectionMap;
    }

    private void evaluateElementCollectionMap(Map<String, ElementCollection> elementCollectionMap) {
        elementCollectionMap.forEach((entityType, elementCollection) -> {
            if (Objects.nonNull(elementCollection.getDynamicRepositoryElement())) {
                RepositoryData repositoryData = this.supplierManager.requestSupply((ElementCollection)elementCollection, new RepositoryData());
                try {
                    this.writeBuilderFile(repositoryData);
                }
                catch (IOException e) {
                    log.error("An exception occurred: {}", (Object)e.getMessage());
                }
            }
        });
    }

    private void writeBuilderFile(RepositoryData repositoryData) throws IOException {
        String simpleClassName = repositoryData.getEntityType() + REPOSITORY_CLASS_SUFFIX;
        String builderClassName = repositoryData.getPackageName() + PACKAGE_SEPARATOR + simpleClassName;
        repositoryData.setSimpleClassName(simpleClassName);
        String file = this.repositoryGenerator.generateRepository(repositoryData);
        JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(builderClassName, new Element[0]);
        try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
            out.println(file);
        }
    }

    public DynamicRepositoryProcessor(SupplierManager supplierManager, RepositoryGenerator repositoryGenerator, Map<String, ElementCollector> fillers) {
        this.supplierManager = supplierManager;
        this.repositoryGenerator = repositoryGenerator;
        this.fillers = fillers;
    }
}

