package io.overcoded.repository.annotation.processor.supplier;

import io.overcoded.repository.annotation.processor.domain.ElementCollection;
import io.overcoded.repository.annotation.processor.domain.RepositoryData;

import java.util.HashSet;

/**
 * @author Diana Ladanyi
 * @author Adam Belak
 */
class DynamicRepositorySupplier extends AbstractSupplier implements Supplier {
    @Override
    public RepositoryData execute(ElementCollection elementCollection, RepositoryData repositoryData) {
        repositoryData.setFindMethods(new HashSet<>());
        repositoryData.setCountMethods(new HashSet<>());
        repositoryData.setEntityType(elementCollection.getDynamicRepositoryElement().getSimpleName().toString());
        repositoryData.setPackageName(elementCollection.getDynamicRepositoryElement().getEnclosingElement().toString());
        return super.execute(elementCollection, repositoryData);
    }
}
