package io.overcoded.repository.annotation.processor.supplier;

import io.overcoded.repository.annotation.processor.domain.ElementCollection;
import io.overcoded.repository.annotation.processor.domain.RepositoryData;
import lombok.Getter;
import lombok.Setter;

import java.util.Objects;

/**
 * @author Diana Ladanyi
 */
@Getter
@Setter
abstract class AbstractSupplier implements Supplier {
    private Supplier next;

    @Override
    public Supplier getLast() {
        Supplier last = this;
        while (Objects.nonNull(last.getNext())) {
            last = last.getNext();
        }
        return last;
    }

    @Override
    public RepositoryData execute(ElementCollection elementCollection, RepositoryData repositoryData) {
        return Objects.nonNull(getNext())
                ? getNext().execute(elementCollection, repositoryData)
                : repositoryData;
    }
}
