package io.overcoded.vaadin.panel;

import com.vaadin.flow.component.icon.VaadinIcon;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

@Getter
@RequiredArgsConstructor
public enum PanelType {
    PRIMARY(VaadinIcon.INFO_CIRCLE_O),
    ERROR(VaadinIcon.EXCLAMATION_CIRCLE_O),
    SUCCESS(VaadinIcon.CHECK_CIRCLE_O);

    private final VaadinIcon icon;

    public String getBadgeBackgroundColor() {
        return "--lumo-" + name().toLowerCase() + "-color-10pct";
    }

    public String getFocusOutlineColor() {
        return "--lumo-" + name().toLowerCase() + "-color-50pct";
    }

    public String getButtonBackgroundColor() {
        return "--lumo-" + name().toLowerCase() + "-color";
    }

    public String getTextColor() {
        return "--lumo-" + name().toLowerCase() + "-text-color";
    }

    public String getContrastColor() {
        return "--lumo-primary-contrast-color";
    }
}
