package io.overcoded.vaadin.panel;

import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;

public class DynamicGridPanel extends VerticalLayout {

    public DynamicGridPanel(PanelType panelType, String errorType, String message) {
        VerticalLayout container = createPanel(panelType, errorType, message);

        add(container);
        setAlignItems(Alignment.CENTER);
        setJustifyContentMode(JustifyContentMode.START);
    }

    private VerticalLayout createPanel(PanelType panelType, String title, String message) {
        VerticalLayout titleHolder = createTitleLayout(panelType, title);
        VerticalLayout textHolder = createMessageLayout(message);

        VerticalLayout container = new VerticalLayout();
        container.add(titleHolder, textHolder);
        container.setSpacing(false);
        container.setMargin(true);
        container.setPadding(false);

        container.getElement().getStyle().set("background-color", "var(" + panelType.getBadgeBackgroundColor() + ")");
        container.getElement().getStyle().set("border", "1px solid var(" + panelType.getButtonBackgroundColor() + ")");
        container.getElement().getStyle().set("border-radius", "var(--lumo-border-radius-s)");
        container.getElement().getStyle().set("color", "var(" + panelType.getTextColor() + ")");
        return container;
    }

    private VerticalLayout createMessageLayout(String message) {
        Text text = new Text(message);
        VerticalLayout textHolder = new VerticalLayout();
        textHolder.add(text);
        textHolder.setSpacing(false);
        textHolder.setMargin(false);
        textHolder.setPadding(true);
        return textHolder;
    }

    private VerticalLayout createTitleLayout(PanelType panelType, String title) {
        VerticalLayout titleHolder = new VerticalLayout();
        titleHolder.add(getTitle(panelType, title));
        titleHolder.setMargin(false);
        titleHolder.setPadding(true);
        return titleHolder;
    }

    private H2 getTitle(PanelType panelType, String titleText) {
        H2 title = new H2(createIcon(panelType.getIcon()), new Span(titleText));
        title.setWidthFull();
        title.getElement().getStyle().set("margin", "0rem");
        title.getElement().getStyle().set("color", "var(" + panelType.getTextColor() + ")");
        title.getElement().getStyle().set("border-bottom", "1px solid var(" + panelType.getButtonBackgroundColor() + ")");
        return title;
    }

    private Icon createIcon(VaadinIcon vaadinIcon) {
        Icon icon = vaadinIcon.create();
        icon.getStyle().set("margin", "var(--lumo-space-s");
        return icon;
    }
}
