package io.overcoded.vaadin.dialog;

import com.vaadin.flow.component.Component;
import io.overcoded.grid.DialogProperties;
import io.overcoded.grid.GridInfo;
import io.overcoded.vaadin.panel.DynamicGridPanelFactory;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class DynamicManyToManyDialog<T, U> extends DynamicDialog<T, U> {
    private final DynamicGridPanelFactory panelFactory;

    public DynamicManyToManyDialog(DynamicGridPanelFactory panelFactory,
                                   DialogProperties dialogProperties,
                                   GridInfo gridInfo) {
        super(dialogProperties, gridInfo);
        this.panelFactory = panelFactory;
    }

    @Override
    protected Component createContent(DynamicDialogParameter<T, U> parameter) {
        return panelFactory.createErrorPanel("Not supported", "Many to many dialog is not implemented yet.");
    }
}
