package io.overcoded.vaadin.dialog;

import io.overcoded.grid.ContextMenuEntry;
import io.overcoded.grid.DialogType;
import lombok.Builder;
import lombok.Data;

/**
 * @param <T> type of the dialog
 * @param <U> type of the parameter (filter column) should be present as field in T
 */
@Data
@Builder
public class DynamicDialogParameter<T, U> {
    private Class<T> type;
    private String property;
    private ContextMenuEntry entry;
    private U parameter;
    private DialogType dialogType;
}
