package io.overcoded.grid.processor;

import io.overcoded.grid.MethodInfoProperties;
import io.overcoded.grid.processor.column.DisplayValueExpressionExtractor;
import io.overcoded.grid.processor.column.FieldProviderTypeDecider;
import io.overcoded.grid.processor.column.JoinFieldFinder;
import io.overcoded.grid.processor.column.NameTransformer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.repository.support.Repositories;

@Configuration(proxyBeanMethods = false)
@Import(DynamicVaadinFieldConfiguration.class)
public class DynamicVaadinGridConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ColumnInfoFactory columnInfoFactory(NameTransformer nameTransformer,
                                               GridDialogValidator gridDialogValidator,
                                               FieldProviderTypeDecider fieldProviderTypeDecider,
                                               DisplayValueExpressionExtractor displayValueExpressionExtractor) {
        return new ColumnInfoFactory(fieldProviderTypeDecider, displayValueExpressionExtractor, gridDialogValidator, nameTransformer);
    }

    @Bean
    @ConditionalOnMissingBean
    public ColumnInfoCollector columnInfoCollector(ColumnInfoFactory columnInfoFactory, FieldCollector fieldCollector) {
        return new ColumnInfoCollector(columnInfoFactory, fieldCollector);
    }

    @Bean
    @ConditionalOnMissingBean
    public JoinFieldFinder joinFieldFinder(FieldCollector fieldCollector, NameTransformer nameTransformer) {
        return new JoinFieldFinder(fieldCollector, nameTransformer);
    }

    @Bean
    @ConditionalOnMissingBean
    public ContextMenuEntryFactory contextMenuEntryFactory(JoinFieldFinder joinFieldFinder, NameTransformer nameTransformer) {
        return new ContextMenuEntryFactory(joinFieldFinder, nameTransformer);
    }

    @Bean
    @ConditionalOnMissingBean
    public ContextMenuGroupFactory contextMenuGroupFactory(ContextMenuEntryFactory contextMenuEntryFactory, GridDialogValidator gridDialogValidator) {
        return new ContextMenuGroupFactory(contextMenuEntryFactory, gridDialogValidator);
    }

    @Bean
    @ConditionalOnMissingBean
    public ContextMenuGroupCollector contextMenuGroupCollector(FieldCollector fieldCollector, ContextMenuGroupFactory contextMenuGroupFactory) {
        return new ContextMenuGroupCollector(fieldCollector, contextMenuGroupFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public MethodInfoFactory methodInfoFactory(Repositories repositories, NameTransformer nameTransformer, MethodInfoProperties methodInfoProperties) {
        return new MethodInfoFactory(repositories, nameTransformer, methodInfoProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public GridInfoViewFactory gridInfoViewFactory(NameTransformer nameTransformer, MethodInfoFactory methodInfoFactory, ColumnInfoCollector columnInfoCollector, ContextMenuGroupCollector contextMenuGroupCollector) {
        return new GridInfoViewFactory(nameTransformer, methodInfoFactory, columnInfoCollector, contextMenuGroupCollector);
    }

    @Bean
    public GridInfoDialogFactory gridInfoDialogFactory(NameTransformer nameTransformer, MethodInfoFactory methodInfoFactory, ColumnInfoCollector columnInfoCollector, ContextMenuGroupCollector contextMenuGroupCollector) {
        return new GridInfoDialogFactory(nameTransformer, methodInfoFactory, columnInfoCollector, contextMenuGroupCollector);
    }
}
