/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client.jsonpatch;

import io.orchestrate.client.jsonpatch.JsonPatchOp;
import java.util.ArrayList;
import java.util.List;

public class JsonPatch {
    private final List<JsonPatchOp> ops;

    public JsonPatch(List<JsonPatchOp> ops) {
        this.ops = ops;
    }

    public List<JsonPatchOp> getOps() {
        return this.ops;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        List<JsonPatchOp> ops = new ArrayList<JsonPatchOp>();

        public Builder add(String path, Object value) {
            this.ops.add(new JsonPatchOp("add", path, value));
            return this;
        }

        public Builder test(String path, Object value) {
            this.ops.add(new JsonPatchOp("test", path, value));
            return this;
        }

        public Builder move(String from, String path) {
            this.ops.add(new JsonPatchOp("move", path, null, from));
            return this;
        }

        public Builder copy(String from, String path) {
            this.ops.add(new JsonPatchOp("copy", path, null, from));
            return this;
        }

        public Builder inc(String path) {
            this.inc(path, null);
            return this;
        }

        public Builder inc(String path, Number value) {
            this.ops.add(new JsonPatchOp("inc", path, value));
            return this;
        }

        public Builder remove(String path) {
            this.ops.add(new JsonPatchOp("remove", path, null, null));
            return this;
        }

        public Builder replace(String path, Object value) {
            this.ops.add(new JsonPatchOp("replace", path, value, null));
            return this;
        }

        public Builder op(JsonPatchOp op) {
            this.ops.add(op);
            return this;
        }

        public JsonPatch build() {
            return new JsonPatch(this.ops);
        }
    }
}

