/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client.dao;

import io.orchestrate.client.Client;
import io.orchestrate.client.KvMetadata;
import io.orchestrate.client.KvObject;
import io.orchestrate.client.Preconditions;
import io.orchestrate.client.ResponseListener;
import io.orchestrate.client.dao.AsyncDao;

public abstract class GenericAsyncDao<T>
implements AsyncDao<T> {
    private final Client client;
    private final String collection;
    private final Class<T> clazz;

    public GenericAsyncDao(Client client, String collection, Class<T> clazz) {
        this.collection = Preconditions.checkNotNullOrEmpty(collection, "collection");
        this.client = Preconditions.checkNotNull(client, "client");
        this.clazz = Preconditions.checkNotNull(clazz, "clazz");
    }

    @Override
    public KvObject<T> findOne(String key) {
        return this.client.kv(this.collection, key).get(this.clazz).get();
    }

    @Override
    public void findOne(String key, Iterable<ResponseListener<KvObject<T>>> listeners) {
        this.client.kv(this.collection, key).get(this.clazz).on(listeners);
    }

    @Override
    public KvObject<T> findOne(String key, KvMetadata metadata) {
        Preconditions.checkNotNull(metadata, "metadata");
        return this.findOne(key, metadata.getRef());
    }

    @Override
    public void findOne(String key, KvMetadata metadata, Iterable<ResponseListener<KvObject<T>>> listeners) {
        Preconditions.checkNotNull(metadata, "metadata");
        this.findOne(key, metadata.getRef(), listeners);
    }

    @Override
    public KvObject<T> findOne(String key, String ref) {
        return this.client.kv(this.collection, key).get(this.clazz, ref).get();
    }

    @Override
    public void findOne(String key, String ref, Iterable<ResponseListener<KvObject<T>>> listeners) {
        this.client.kv(this.collection, key).get(this.clazz, ref).on(listeners);
    }

    @Override
    public KvMetadata save(String key, T value) {
        return this.client.kv(this.collection, key).put(value).get();
    }

    @Override
    public void save(String key, T value, Iterable<ResponseListener<KvMetadata>> listeners) {
        this.client.kv(this.collection, key).put(value).on(listeners);
    }

    @Override
    public KvMetadata save(String key, T value, boolean ifAbsent) {
        return this.client.kv(this.collection, key).ifAbsent(ifAbsent).put(value).get();
    }

    @Override
    public void save(String key, T value, boolean ifAbsent, Iterable<ResponseListener<KvMetadata>> listeners) {
        this.client.kv(this.collection, key).ifAbsent(ifAbsent).put(value).on(listeners);
    }

    @Override
    public KvMetadata save(String key, T value, KvMetadata metadata) {
        Preconditions.checkNotNull(metadata, "metadata");
        return this.save(key, value, metadata.getRef());
    }

    @Override
    public void save(String key, T value, KvMetadata metadata, Iterable<ResponseListener<KvMetadata>> listeners) {
        Preconditions.checkNotNull(metadata, "metadata");
        this.save(key, value, metadata.getRef(), listeners);
    }

    @Override
    public KvMetadata save(String key, T value, String currentRef) {
        return this.client.kv(this.collection, key).ifMatch(currentRef).put(value).get();
    }

    @Override
    public void save(String key, T value, String currentRef, Iterable<ResponseListener<KvMetadata>> listeners) {
        this.client.kv(this.collection, key).ifMatch(currentRef).put(value).on(listeners);
    }

    @Override
    public Boolean delete(String key) {
        return this.client.kv(this.collection, key).delete().get();
    }

    @Override
    public void delete(String key, Iterable<ResponseListener<Boolean>> listeners) {
        this.client.kv(this.collection, key).delete().on(listeners);
    }

    @Override
    public Boolean delete(String key, KvMetadata metadata) {
        Preconditions.checkNotNull(metadata, "metadata");
        return this.delete(key, metadata.getRef());
    }

    @Override
    public void delete(String key, KvMetadata metadata, Iterable<ResponseListener<Boolean>> listeners) {
        Preconditions.checkNotNull(metadata, "metadata");
        this.delete(key, metadata.getRef(), listeners);
    }

    @Override
    public Boolean delete(String key, String currentRef) {
        return this.client.kv(this.collection, key).ifMatch(currentRef).delete().get();
    }

    @Override
    public void delete(String key, String currentRef, Iterable<ResponseListener<Boolean>> listeners) {
        this.client.kv(this.collection, key).ifMatch(currentRef).delete().on(listeners);
    }

    @Override
    public Boolean deleteCollection() {
        return this.client.deleteCollection(this.collection).get();
    }

    @Override
    public void deleteCollection(Iterable<ResponseListener<Boolean>> listeners) {
        this.client.deleteCollection(this.collection).on(listeners);
    }
}

