/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.databind.JsonNode;
import io.orchestrate.client.BaseResource;
import io.orchestrate.client.Event;
import io.orchestrate.client.EventMetadata;
import io.orchestrate.client.JacksonMapper;
import io.orchestrate.client.OrchestrateClient;
import io.orchestrate.client.OrchestrateRequest;
import io.orchestrate.client.ResponseConverter;
import io.orchestrate.client.ResponseConverterUtil;
import io.orchestrate.client.jsonpatch.JsonPatch;
import java.io.IOException;
import java.nio.ByteBuffer;
import lombok.NonNull;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.memory.ByteBufferWrapper;

public class SingleEventResource
extends BaseResource {
    private final String collection;
    private final String key;
    private final String eventType;
    private final Long timestamp;
    private final String ordinal;
    private String ifMatchRef;

    SingleEventResource(OrchestrateClient client, JacksonMapper mapper, String collection, String key, String eventType, Long timestamp, String ordinal) {
        super(client, mapper);
        assert (collection != null);
        assert (collection.length() > 0);
        assert (key != null);
        assert (key.length() > 0);
        assert (eventType != null);
        assert (eventType.length() > 0);
        assert (timestamp != null);
        assert (ordinal != null);
        this.collection = collection;
        this.key = key;
        this.eventType = eventType;
        this.timestamp = timestamp;
        this.ordinal = ordinal;
    }

    public SingleEventResource ifMatch(String ref) {
        this.ifMatchRef = ref;
        return this;
    }

    public <T> OrchestrateRequest<Event<T>> get(final Class<T> clazz) {
        String uri = this.buildUri();
        HttpContent packet = HttpRequestPacket.builder().method(Method.GET).uri(uri).build().httpContentBuilder().build();
        return new OrchestrateRequest<Event<T>>(this.client, packet, new ResponseConverter<Event<T>>(){

            @Override
            public Event<T> from(HttpContent response) throws IOException {
                HttpHeader header = response.getHttpHeader();
                int status = ((HttpResponsePacket)header).getStatus();
                if (status == 404) {
                    return null;
                }
                String rawWrapperJson = response.getContent().toStringContent();
                JsonNode jsonNode = SingleEventResource.this.mapper.readTree(rawWrapperJson);
                return ResponseConverterUtil.wrapperJsonToEvent(SingleEventResource.this.mapper, jsonNode, clazz);
            }
        });
    }

    private String buildUri() {
        return this.client.uri(this.collection, this.key, "events", this.eventType, "" + this.timestamp, this.ordinal);
    }

    public OrchestrateRequest<Boolean> purge() {
        String uri = this.buildUri();
        HttpRequestPacket.Builder builder = HttpRequestPacket.builder().method(Method.DELETE).query("purge=true").uri(uri);
        if (this.ifMatchRef != null) {
            builder.header(Header.IfMatch, "\"".concat(this.ifMatchRef).concat("\""));
        }
        HttpContent packet = builder.build().httpContentBuilder().build();
        return new OrchestrateRequest<Boolean>(this.client, packet, new ResponseConverter<Boolean>(){

            @Override
            public Boolean from(HttpContent response) throws IOException {
                int status = ((HttpResponsePacket)response.getHttpHeader()).getStatus();
                return status == HttpStatus.NO_CONTENT_204.getStatusCode();
            }
        });
    }

    public OrchestrateRequest<EventMetadata> update(@NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        byte[] content = this.toJsonBytes(value);
        String uri = this.buildUri();
        HttpRequestPacket.Builder httpHeaderBuilder = (HttpRequestPacket.Builder)((HttpRequestPacket.Builder)HttpRequestPacket.builder().method(Method.PUT).contentType("application/json")).uri(uri).contentLength((long)content.length);
        if (this.ifMatchRef != null) {
            httpHeaderBuilder.header(Header.IfMatch, "\"".concat(this.ifMatchRef).concat("\""));
        }
        HttpContent packet = httpHeaderBuilder.build().httpContentBuilder().content((Buffer)new ByteBufferWrapper(ByteBuffer.wrap(content))).build();
        return new OrchestrateRequest<EventMetadata>(this.client, packet, new EventMetadataResponseConverter());
    }

    public OrchestrateRequest<EventMetadata> patch(JsonPatch patchOps) {
        byte[] content = this.toJsonBytes(patchOps.getOps());
        String uri = this.buildUri();
        HttpRequestPacket.Builder httpHeaderBuilder = (HttpRequestPacket.Builder)((HttpRequestPacket.Builder)HttpRequestPacket.builder().method(Method.PATCH).contentType("application/json-patch+json")).uri(uri).contentLength((long)content.length);
        if (this.ifMatchRef != null) {
            httpHeaderBuilder.header(Header.IfMatch, "\"".concat(this.ifMatchRef).concat("\""));
        }
        HttpContent packet = httpHeaderBuilder.build().httpContentBuilder().content((Buffer)new ByteBufferWrapper(ByteBuffer.wrap(content))).build();
        return new OrchestrateRequest<EventMetadata>(this.client, packet, new EventMetadataResponseConverter());
    }

    public OrchestrateRequest<EventMetadata> merge(String jsonString) {
        byte[] content = this.toJsonBytes(jsonString);
        String uri = this.buildUri();
        HttpRequestPacket.Builder httpHeaderBuilder = (HttpRequestPacket.Builder)((HttpRequestPacket.Builder)HttpRequestPacket.builder().method(Method.PATCH).contentType("application/merge-patch+json")).uri(uri).contentLength((long)content.length);
        if (this.ifMatchRef != null) {
            httpHeaderBuilder.header(Header.IfMatch, "\"".concat(this.ifMatchRef).concat("\""));
        }
        HttpContent packet = httpHeaderBuilder.build().httpContentBuilder().content((Buffer)new ByteBufferWrapper(ByteBuffer.wrap(content))).build();
        return new OrchestrateRequest<EventMetadata>(this.client, packet, new EventMetadataResponseConverter());
    }

    class EventMetadataResponseConverter
    implements ResponseConverter<EventMetadata> {
        EventMetadataResponseConverter() {
        }

        @Override
        public EventMetadata from(HttpContent response) throws IOException {
            HttpHeader header = response.getHttpHeader();
            int status = ((HttpResponsePacket)header).getStatus();
            if (status == 201 || status == 204) {
                String location = header.getHeader(Header.Location);
                String[] parts = location.split("/");
                Long timestamp = new Long(parts[6]);
                String ordinal = parts[7];
                String ref = header.getHeader(Header.ETag).replace("\"", "").replace("-gzip", "");
                return new EventMetadata(SingleEventResource.this.collection, SingleEventResource.this.key, SingleEventResource.this.eventType, timestamp, ordinal, ref);
            }
            return null;
        }
    }
}

