/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.orchestrate.client.Event;
import io.orchestrate.client.KvMetadata;
import io.orchestrate.client.KvObject;
import java.io.IOException;

final class ResponseConverterUtil {
    ResponseConverterUtil() {
    }

    static <T> KvObject<T> jsonToKvObject(ObjectMapper mapper, JsonNode jsonNode, Class<T> clazz) throws IOException {
        assert (mapper != null);
        assert (jsonNode != null);
        assert (clazz != null);
        JsonNode path = jsonNode.get("path");
        String collection = path.get("collection").asText();
        String key = path.get("key").asText();
        String ref = path.get("ref").asText();
        JsonNode valueNode = jsonNode.get("value");
        return ResponseConverterUtil.jsonToKvObject(mapper, valueNode, clazz, collection, key, ref);
    }

    public static <T> KvObject<T> jsonToKvObject(ObjectMapper mapper, JsonNode valueNode, Class<T> clazz, String collection, String key, String ref) throws IOException {
        assert (mapper != null);
        assert (clazz != null);
        KvMetadata metadata = new KvMetadata(collection, key, ref);
        T value = ResponseConverterUtil.jsonToDomainObject(mapper, valueNode, clazz);
        String rawValue = null;
        if (value != null && value instanceof String) {
            rawValue = (String)value;
        }
        return new KvObject<T>(mapper, metadata, value, rawValue);
    }

    public static <T> KvObject<T> jsonToKvObject(ObjectMapper mapper, String rawValue, Class<T> clazz, String collection, String key, String ref) throws IOException {
        assert (mapper != null);
        assert (clazz != null);
        KvMetadata metadata = new KvMetadata(collection, key, ref);
        T value = ResponseConverterUtil.jsonToDomainObject(mapper, rawValue, clazz);
        return new KvObject<T>(mapper, metadata, value, rawValue);
    }

    public static <T> T jsonToDomainObject(ObjectMapper mapper, String rawValue, Class<T> clazz) throws IOException {
        if (rawValue != null && !rawValue.isEmpty()) {
            if (clazz.equals(String.class)) {
                return (T)rawValue;
            }
            return (T)mapper.readValue(rawValue, clazz);
        }
        return null;
    }

    public static <T> T jsonToDomainObject(ObjectMapper mapper, JsonNode json, Class<T> clazz) throws IOException {
        if (json != null && !json.isNull()) {
            if (clazz.equals(String.class)) {
                return (T)mapper.writeValueAsString((Object)json);
            }
            return (T)mapper.treeToValue((TreeNode)json, clazz);
        }
        return null;
    }

    public static <T> Event<T> wrapperJsonToEvent(ObjectMapper mapper, JsonNode wrapperJson, Class<T> clazz) throws IOException {
        assert (mapper != null);
        assert (clazz != null);
        JsonNode path = wrapperJson.get("path");
        String collection = path.get("collection").textValue();
        String key = path.get("key").textValue();
        String eventType = path.get("type").textValue();
        String ref = path.get("ref").textValue();
        long timestamp = path.get("timestamp").longValue();
        String ordinal = path.get("ordinal").asText();
        JsonNode valueNode = wrapperJson.get("value");
        T value = ResponseConverterUtil.jsonToDomainObject(mapper, valueNode, clazz);
        String rawValue = null;
        if (value != null && value instanceof String) {
            rawValue = (String)value;
        }
        return new Event<T>(mapper, collection, key, eventType, timestamp, ordinal, ref, value, rawValue);
    }
}

