/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.orchestrate.client.KvMetadata;

public class KvObject<T>
extends KvMetadata {
    private final ObjectMapper mapper;
    private final T value;
    private String rawValue;

    KvObject(ObjectMapper mapper, KvMetadata metadata, T value, String rawValue) {
        super(metadata.getCollection(), metadata.getKey(), metadata.getRef());
        this.mapper = mapper;
        this.value = value;
        this.rawValue = rawValue;
    }

    public final T getValue() {
        return this.value;
    }

    public final String getRawValue() {
        if (this.rawValue == null && this.value != null) {
            try {
                this.rawValue = this.mapper.writeValueAsString(this.value);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return this.rawValue;
    }

    @Override
    public String toString() {
        return "KvObject(super=" + super.toString() + ", mapper=" + this.mapper + ", value=" + this.getValue() + ", rawValue=" + this.getRawValue() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KvObject)) {
            return false;
        }
        KvObject other = (KvObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectMapper this$mapper = this.mapper;
        ObjectMapper other$mapper = other.mapper;
        if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$rawValue = this.getRawValue();
        String other$rawValue = other.getRawValue();
        return !(this$rawValue == null ? other$rawValue != null : !this$rawValue.equals(other$rawValue));
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof KvObject;
    }

    @Override
    public int hashCode() {
        int PRIME = 277;
        int result = 1;
        result = result * 277 + super.hashCode();
        ObjectMapper $mapper = this.mapper;
        result = result * 277 + ($mapper == null ? 0 : $mapper.hashCode());
        T $value = this.getValue();
        result = result * 277 + ($value == null ? 0 : $value.hashCode());
        String $rawValue = this.getRawValue();
        result = result * 277 + ($rawValue == null ? 0 : $rawValue.hashCode());
        return result;
    }
}

