/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import lombok.NonNull;

public final class JacksonMapper {
    private final Builder builder;

    public JacksonMapper() {
        this(JacksonMapper.builder());
    }

    private JacksonMapper(Builder builder) {
        assert (builder != null);
        this.builder = builder;
    }

    ObjectMapper getMapper() {
        return this.builder.objectMapper;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@NonNull ObjectMapper objectMapper) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper");
        }
        return new Builder(objectMapper);
    }

    public static final class Builder {
        private final ObjectMapper objectMapper;

        private Builder() {
            this(new ObjectMapper());
        }

        private Builder(ObjectMapper objectMapper) {
            assert (objectMapper != null);
            this.objectMapper = objectMapper;
        }

        public Builder registerModule(@NonNull Module module) {
            if (module == null) {
                throw new NullPointerException("module");
            }
            this.objectMapper.registerModule(module);
            return this;
        }

        public Builder enable(DeserializationFeature ... features) {
            if (features == null) {
                throw new NullPointerException("features");
            }
            if (features.length < 1) {
                throw new IllegalArgumentException("'features' cannot be empty.");
            }
            for (DeserializationFeature feature : features) {
                this.objectMapper.enable(feature);
            }
            return this;
        }

        public Builder enable(MapperFeature ... features) {
            if (features == null) {
                throw new NullPointerException("features");
            }
            if (features.length < 1) {
                throw new IllegalArgumentException("'features' cannot be empty.");
            }
            this.objectMapper.enable(features);
            return this;
        }

        public Builder enable(SerializationFeature ... features) {
            if (features == null) {
                throw new NullPointerException("features");
            }
            if (features.length < 1) {
                throw new IllegalArgumentException("'features' cannot be empty.");
            }
            for (SerializationFeature feature : features) {
                this.objectMapper.enable(feature);
            }
            return this;
        }

        public Builder enable(JsonGenerator.Feature ... features) {
            if (features == null) {
                throw new NullPointerException("features");
            }
            if (features.length < 1) {
                throw new IllegalArgumentException("'features' cannot be empty.");
            }
            for (JsonGenerator.Feature feature : features) {
                this.objectMapper.getFactory().enable(feature);
            }
            return this;
        }

        public Builder enable(JsonParser.Feature ... features) {
            if (features == null) {
                throw new NullPointerException("features");
            }
            if (features.length < 1) {
                throw new IllegalArgumentException("'features' cannot be empty.");
            }
            for (JsonParser.Feature feature : features) {
                this.objectMapper.getFactory().enable(feature);
            }
            return this;
        }

        public Builder disable(DeserializationFeature ... features) {
            if (features == null) {
                throw new NullPointerException("features");
            }
            if (features.length < 1) {
                throw new IllegalArgumentException("'features' cannot be empty.");
            }
            for (DeserializationFeature feature : features) {
                this.objectMapper.disable(feature);
            }
            return this;
        }

        public Builder disable(MapperFeature ... features) {
            if (features == null) {
                throw new NullPointerException("features");
            }
            if (features.length < 1) {
                throw new IllegalArgumentException("'features' cannot be empty.");
            }
            this.objectMapper.disable(features);
            return this;
        }

        public Builder disable(SerializationFeature ... features) {
            if (features == null) {
                throw new NullPointerException("features");
            }
            if (features.length < 1) {
                throw new IllegalArgumentException("'features' cannot be empty.");
            }
            for (SerializationFeature feature : features) {
                this.objectMapper.disable(feature);
            }
            return this;
        }

        public Builder disable(JsonGenerator.Feature ... features) {
            if (features == null) {
                throw new NullPointerException("features");
            }
            if (features.length < 1) {
                throw new IllegalArgumentException("'features' cannot be empty.");
            }
            for (JsonGenerator.Feature feature : features) {
                this.objectMapper.getFactory().disable(feature);
            }
            return this;
        }

        public Builder disable(JsonParser.Feature ... features) {
            if (features == null) {
                throw new NullPointerException("features");
            }
            if (features.length < 1) {
                throw new IllegalArgumentException("'features' cannot be empty.");
            }
            for (JsonParser.Feature feature : features) {
                this.objectMapper.getFactory().disable(feature);
            }
            return this;
        }

        public JacksonMapper build() {
            return new JacksonMapper(this);
        }
    }
}

