/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.orchestrate.client.ApiBadRequestException;
import io.orchestrate.client.InvalidApiKeyException;
import io.orchestrate.client.ItemAlreadyPresentException;
import io.orchestrate.client.ItemVersionMismatchException;
import io.orchestrate.client.PatchConflictException;
import io.orchestrate.client.RequestException;
import io.orchestrate.client.TestOpApplyException;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import javax.annotation.Nullable;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.Base64Utils;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientFilter
extends BaseFilter {
    private static final Logger log = LoggerFactory.getLogger(ClientFilter.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public static final String OIO_RESPONSE_FUTURE_ATTR = "httpResp";
    private static final String BASE_USER_AGENT = ClientFilter.buildBaseUserAgent();
    private final Attribute<SafeFutureImpl<HttpContent>> httpResponseAttr;
    private final String authHeaderValue;
    private final String userAgentValue;
    private final String host;

    ClientFilter(String apiKey, URI host, @Nullable String userAgent) {
        assert (apiKey != null);
        assert (host != null);
        this.httpResponseAttr = AttributeBuilder.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(OIO_RESPONSE_FUTURE_ATTR);
        this.authHeaderValue = "Basic ".concat(Base64Utils.encodeToString((byte[])apiKey.getBytes(), (boolean)true));
        this.userAgentValue = userAgent == null ? BASE_USER_AGENT : String.format("%s %s", BASE_USER_AGENT, userAgent);
        this.host = host.getHost();
    }

    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        SafeFutureImpl future = (SafeFutureImpl)this.httpResponseAttr.get(ctx.getConnection().getAttributes());
        future.failure(error);
        super.exceptionOccurred(ctx, error);
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        SafeFutureImpl future = (SafeFutureImpl)this.httpResponseAttr.get(ctx.getConnection().getAttributes());
        try {
            HttpContent content = (HttpContent)ctx.getMessage();
            if (!content.isLast()) {
                return ctx.getStopAction((Object)content);
            }
            HttpHeader header = content.getHttpHeader();
            int status = ((HttpResponsePacket)header).getStatus();
            log.info("Received content: {}", (Object)header);
            if (status == 200 || status == 201 || status == 204 || status == 404) {
                future.result((Object)content);
            } else {
                String reqId = header.getHeader("x-orchestrate-req-id");
                String json = content.getContent().toStringContent();
                future.failure((Throwable)this.toException(status, reqId, json));
            }
        }
        catch (Throwable t) {
            future.failure(t);
        }
        return ctx.getStopAction();
    }

    private Exception toException(int status, String reqId, String json) {
        JsonNode errorJsonNode = this.parseErrorJsonNode(json);
        if (errorJsonNode != null && errorJsonNode.isObject() && errorJsonNode.has("code")) {
            String errorCode = errorJsonNode.get("code").asText();
            if (errorCode.equals("item_version_mismatch")) {
                return new ItemVersionMismatchException(status, errorJsonNode, json, reqId);
            }
            if (errorCode.equals("item_already_present")) {
                return new ItemAlreadyPresentException(status, errorJsonNode, json, reqId);
            }
            if (errorCode.equals("patch_conflict")) {
                JsonNode opNode;
                JsonNode details;
                if (errorJsonNode.has("details") && (details = errorJsonNode.get("details")).has("op") && (opNode = details.get("op")).has("op") && opNode.get("op").textValue().equals("test")) {
                    return new TestOpApplyException(status, errorJsonNode, json, reqId);
                }
                return new PatchConflictException(status, errorJsonNode, json, reqId);
            }
            if (errorCode.equals("api_bad_request")) {
                return new ApiBadRequestException(status, errorJsonNode, json, reqId);
            }
        }
        if (status == 401) {
            return new InvalidApiKeyException(status, errorJsonNode, json, reqId);
        }
        return new RequestException(status, errorJsonNode, json, reqId);
    }

    private JsonNode parseErrorJsonNode(String json) {
        try {
            return MAPPER.readTree(json);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Object message = ctx.getMessage();
        if (!(message instanceof HttpPacket)) {
            return ctx.getInvokeAction();
        }
        HttpPacket request = (HttpPacket)message;
        HttpRequestPacket httpHeader = (HttpRequestPacket)request.getHttpHeader();
        httpHeader.setProtocol(Protocol.HTTP_1_1);
        httpHeader.setHeader(Header.Host, this.host);
        httpHeader.setHeader(Header.UserAgent, this.userAgentValue);
        httpHeader.addHeader(Header.Authorization, this.authHeaderValue);
        log.info("Sending request: {}", (Object)httpHeader);
        ctx.write((Object)request);
        return ctx.getStopAction();
    }

    private static String buildBaseUserAgent() {
        String version = "unknown";
        try {
            Properties props = new Properties();
            String basePath = "/" + ClientFilter.class.getPackage().getName().replace('.', '/');
            props.load(ClientFilter.class.getResourceAsStream(basePath + "/build.properties"));
            if (props.containsKey("version")) {
                version = props.getProperty("version");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.format("OrchestrateJavaClient/%s (Java/%s; %s)", version, System.getProperty("java.version"), System.getProperty("java.vendor"));
    }
}

