/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import io.orchestrate.client.ClientException;

public class RequestException
extends ClientException {
    private final int statusCode;
    private final String requestId;

    RequestException(int statusCode, String message, String requestId) {
        super(message);
        assert (statusCode >= 0);
        assert (message != null);
        assert (message.length() >= 0);
        assert (requestId != null);
        assert (requestId.length() > 0);
        this.statusCode = statusCode;
        this.requestId = requestId;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public String toString() {
        return "RequestException(statusCode=" + this.getStatusCode() + ", requestId=" + this.getRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestException)) {
            return false;
        }
        RequestException other = (RequestException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatusCode() != other.getStatusCode()) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        return !(this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId));
    }

    public boolean canEqual(Object other) {
        return other instanceof RequestException;
    }

    public int hashCode() {
        int PRIME = 277;
        int result = 1;
        result = result * 277 + this.getStatusCode();
        String $requestId = this.getRequestId();
        result = result * 277 + ($requestId == null ? 0 : $requestId.hashCode());
        return result;
    }
}

