/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

public class Event<T> {
    private final T value;
    private final String rawValue;
    private final long timestamp;
    private final String ordinal;

    Event(T value, String rawValue, long timestamp, String ordinal) {
        assert (value != null);
        assert (rawValue != null);
        assert (timestamp >= 0L);
        this.value = value;
        this.rawValue = rawValue;
        this.timestamp = timestamp;
        this.ordinal = ordinal;
    }

    public final T getValue() {
        return this.value;
    }

    public final String getRawValue() {
        return this.rawValue;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final String getOrdinal() {
        return this.ordinal;
    }

    public String toString() {
        return "Event(value=" + this.getValue() + ", rawValue=" + this.getRawValue() + ", timestamp=" + this.getTimestamp() + ", ordinal=" + this.getOrdinal() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$rawValue = this.getRawValue();
        String other$rawValue = other.getRawValue();
        if (this$rawValue == null ? other$rawValue != null : !this$rawValue.equals(other$rawValue)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$ordinal = this.getOrdinal();
        String other$ordinal = other.getOrdinal();
        return !(this$ordinal == null ? other$ordinal != null : !this$ordinal.equals(other$ordinal));
    }

    public boolean canEqual(Object other) {
        return other instanceof Event;
    }

    public int hashCode() {
        int PRIME = 277;
        int result = 1;
        T $value = this.getValue();
        result = result * 277 + ($value == null ? 0 : $value.hashCode());
        String $rawValue = this.getRawValue();
        result = result * 277 + ($rawValue == null ? 0 : $rawValue.hashCode());
        long $timestamp = this.getTimestamp();
        result = result * 277 + (int)($timestamp >>> 32 ^ $timestamp);
        String $ordinal = this.getOrdinal();
        result = result * 277 + ($ordinal == null ? 0 : $ordinal.hashCode());
        return result;
    }
}

