/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import io.orchestrate.client.OrchestrateRequest;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.http.HttpContent;

final class ConnectionCompletionHandler
implements CompletionHandler<Connection> {
    private final OrchestrateRequest orchestrateRequest;
    private final HttpContent rawRequest;

    public ConnectionCompletionHandler(OrchestrateRequest orchestrateRequest, HttpContent rawRequest) {
        assert (orchestrateRequest != null);
        assert (rawRequest != null);
        this.orchestrateRequest = orchestrateRequest;
        this.rawRequest = rawRequest;
    }

    public void cancelled() {
        this.orchestrateRequest.cancel(false);
    }

    public void failed(Throwable t) {
        this.orchestrateRequest.failed(t);
    }

    public void completed(Connection conn) {
        AttributeHolder attrs = conn.getAttributes();
        attrs.setAttribute("httpResp", this.orchestrateRequest.getRawResponseFuture());
        if (!this.orchestrateRequest.isCancelled()) {
            GrizzlyFuture write = conn.write((Object)this.rawRequest);
            this.orchestrateRequest.setActiveRequest(write);
        }
    }

    public void updated(Connection connection) {
    }
}

