/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.orchestrate.client.JacksonMapper;
import io.orchestrate.client.KvObject;
import io.orchestrate.client.OrchestrateClient;
import io.orchestrate.client.ResponseConverterUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.utils.BufferInputStream;

abstract class BaseResource {
    protected final OrchestrateClient client;
    protected final ObjectMapper mapper;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    BaseResource(OrchestrateClient client, JacksonMapper mapper) {
        assert (client != null);
        assert (mapper != null);
        this.client = client;
        this.mapper = mapper.getMapper();
    }

    protected byte[] toJsonBytes(Object value) {
        try {
            return value instanceof String ? ((String)value).getBytes(UTF8) : this.mapper.writeValueAsBytes(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected JsonNode toJsonNode(HttpContent response) throws IOException {
        return this.mapper.readTree((InputStream)new BufferInputStream(response.getContent()));
    }

    protected <T> KvObject<T> toKvObject(JsonNode result, Class<T> clazz) throws IOException {
        return ResponseConverterUtil.jsonToKvObject(this.mapper, result, clazz);
    }

    protected <T> KvObject<T> toKvObject(HttpContent response, String collection, String key, Class<T> clazz) throws IOException {
        JsonNode valueNode = this.toJsonNode(response);
        String ref = response.getHttpHeader().getHeader(Header.ETag).replace("\"", "").replaceFirst("-gzip$", "");
        return ResponseConverterUtil.jsonToKvObject(this.mapper, valueNode, clazz, collection, key, ref);
    }

    protected <T> T toDomainObject(String rawValue, Class<T> clazz) throws IOException {
        return (T)(clazz == String.class ? rawValue : this.mapper.readValue(rawValue, clazz));
    }
}

