/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.orchestrate.client;

import java.util.Iterator;
import java.util.List;

/**
 * A container for event objects.
 */
public class EventList<T> implements Iterable<Event<T>> {

    /** The event objects from the request. */
    private final List<Event<T>> events;

    EventList(final List<Event<T>> events) {
        assert (events != null);

        this.events = events;
    }

    /**
     * Returns the event objects from the response.
     *
     * @return The event objects.
     */
    public final Iterable<Event<T>> getEvents() {
        return events;
    }

    /** {@inheritDoc} */
    @Override
    public Iterator<Event<T>> iterator() {
        return events.iterator();
    }

}
