/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import io.orchestrate.client.BaseResource;
import io.orchestrate.client.JacksonMapper;
import io.orchestrate.client.OrchestrateClient;
import io.orchestrate.client.OrchestrateRequest;
import io.orchestrate.client.Preconditions;
import io.orchestrate.client.RelationList;
import io.orchestrate.client.ResponseConverter;
import java.io.IOException;
import java.util.ArrayList;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.util.HttpStatus;

public class RelationResource
extends BaseResource {
    private String sourceCollection;
    private String sourceKey;
    private String destCollection;
    private String destKey;
    private boolean invert;

    RelationResource(OrchestrateClient client, JacksonMapper mapper, String sourceCollection, String sourceKey) {
        super(client, mapper);
        assert (sourceCollection != null);
        assert (sourceKey != null);
        this.sourceCollection = sourceCollection;
        this.sourceKey = sourceKey;
    }

    public <T> OrchestrateRequest<RelationList<T>> get(final Class<T> clazz, String ... kinds) {
        Preconditions.checkNotNull(clazz, "clazz");
        Preconditions.checkArgument(this.destCollection == null && this.destKey == null, "'destCollection' and 'destKey' not valid in GET query.");
        Preconditions.checkNoneEmpty(kinds, "kinds", "kind");
        String uri = this.client.uri(this.sourceCollection, this.sourceKey, "relations").concat("/" + this.client.encode(kinds));
        HttpContent packet = HttpRequestPacket.builder().method(Method.GET).uri(uri).build().httpContentBuilder().build();
        return new OrchestrateRequest<RelationList<T>>(this.client, packet, new ResponseConverter<RelationList<T>>(){

            @Override
            public RelationList<T> from(HttpContent response) throws IOException {
                int status = ((HttpResponsePacket)response.getHttpHeader()).getStatus();
                assert (status == 200 || status == 404);
                if (status == 404) {
                    return null;
                }
                JsonNode jsonNode = RelationResource.this.toJsonNode(response);
                int count = jsonNode.path("count").asInt();
                ArrayList relatedObjects = new ArrayList(count);
                for (JsonNode node : jsonNode.path("results")) {
                    relatedObjects.add(RelationResource.this.toKvObject(node, clazz));
                }
                return new RelationList(relatedObjects);
            }
        });
    }

    public OrchestrateRequest<Boolean> put(String kind) {
        Preconditions.checkNotNullOrEmpty(kind, "kind");
        Preconditions.checkArgument(this.destCollection != null && this.destKey != null, "'destCollection' and 'destKey' required for PUT query.");
        String localSourceCollection = this.invert ? this.destCollection : this.sourceCollection;
        String localSourceKey = this.invert ? this.destKey : this.sourceKey;
        String localDestCollection = this.invert ? this.sourceCollection : this.destCollection;
        String localDestKey = this.invert ? this.sourceKey : this.destKey;
        String uri = this.client.uri(localSourceCollection, localSourceKey, "relation", kind, localDestCollection, localDestKey);
        HttpContent packet = HttpRequestPacket.builder().method(Method.PUT).uri(uri).build().httpContentBuilder().build();
        return new OrchestrateRequest<Boolean>(this.client, packet, new ResponseConverter<Boolean>(){

            @Override
            public Boolean from(HttpContent response) throws IOException {
                int status = ((HttpResponsePacket)response.getHttpHeader()).getStatus();
                return status == HttpStatus.NO_CONTENT_204.getStatusCode();
            }
        });
    }

    public OrchestrateRequest<Boolean> purge(String kind) {
        Preconditions.checkNotNullOrEmpty(kind, "kind");
        Preconditions.checkArgument(this.destCollection != null && this.destKey != null, "'destCollection' and 'destKey' required for DELETE query.");
        String localSourceCollection = this.invert ? this.destCollection : this.sourceCollection;
        String localSourceKey = this.invert ? this.destKey : this.sourceKey;
        String localDestCollection = this.invert ? this.sourceCollection : this.destCollection;
        String localDestKey = this.invert ? this.sourceKey : this.destKey;
        String uri = this.client.uri(localSourceCollection, localSourceKey, "relation", kind, localDestCollection, localDestKey);
        HttpContent packet = HttpRequestPacket.builder().method(Method.DELETE).uri(uri).query("purge=true").build().httpContentBuilder().build();
        return new OrchestrateRequest<Boolean>(this.client, packet, new ResponseConverter<Boolean>(){

            @Override
            public Boolean from(HttpContent response) throws IOException {
                int status = ((HttpResponsePacket)response.getHttpHeader()).getStatus();
                return status == HttpStatus.NO_CONTENT_204.getStatusCode();
            }
        });
    }

    public RelationResource to(String collection, String key) {
        this.destCollection = Preconditions.checkNotNullOrEmpty(collection, "collection");
        this.destKey = Preconditions.checkNotNullOrEmpty(key, "key");
        return this;
    }

    public RelationResource invert() {
        return this.invert(Boolean.TRUE);
    }

    public RelationResource invert(boolean invert) {
        this.invert = invert;
        return this;
    }

    private static JsonNode parseJson(String json, ObjectMapper mapper) throws IOException {
        assert (mapper != null);
        try {
            if (json != null) {
                return mapper.readTree(json);
            }
        }
        catch (JsonMappingException jsonMappingException) {
            // empty catch block
        }
        return MissingNode.getInstance();
    }
}

