/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

public final class Preconditions {
    public static <T> T checkNotNull(T value, String paramName) {
        if (value == null) {
            String msg = String.format("'%s' cannot be null.", paramName);
            throw new NullPointerException(msg);
        }
        return value;
    }

    public static String checkNotNullOrEmpty(String value, String paramName) {
        Preconditions.checkNotNull(value, paramName);
        if (value.length() < 1) {
            String msg = String.format("'%s' cannot be empty.", paramName);
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    public static void checkArgument(boolean condition, String errorMsg) {
        if (!condition) {
            throw new IllegalArgumentException(errorMsg);
        }
    }

    public static int checkNotNegative(int value, String paramName) {
        if (value < 0) {
            String msg = String.format("'%s' cannot be negative.", paramName);
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    public static long checkNotNegative(long value, String paramName) {
        if (value < 0L) {
            String msg = String.format("'%s' cannot be negative.", paramName);
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    public static String[] checkNoneEmpty(String[] values, String paramName, String itemName) {
        if (values == null || values.length < 1) {
            String msg = String.format("'%s' cannot be empty.", paramName);
            throw new IllegalArgumentException(msg);
        }
        for (String item : values) {
            Preconditions.checkNotNullOrEmpty(item, itemName);
        }
        return values;
    }
}

