/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orchestrate.client.Client;
import io.orchestrate.client.ClientFilter;
import io.orchestrate.client.CollectionSearchResource;
import io.orchestrate.client.ConnectionCompletionHandler;
import io.orchestrate.client.EventResource;
import io.orchestrate.client.JacksonMapper;
import io.orchestrate.client.KvListResource;
import io.orchestrate.client.KvResource;
import io.orchestrate.client.OrchestrateRequest;
import io.orchestrate.client.Preconditions;
import io.orchestrate.client.RelationResource;
import io.orchestrate.client.ResponseConverter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import lombok.NonNull;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.HttpClientFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.UEncoder;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrchestrateClient
implements Client {
    private static final Logger log = LoggerFactory.getLogger(OrchestrateClient.class);
    private final Builder builder;
    private final NIOTransport transport;
    private static final ThreadLocal<UEncoder> ENCODER_HOLDER = new ThreadLocal<UEncoder>(){

        @Override
        protected UEncoder initialValue() {
            return new UEncoder();
        }
    };

    public OrchestrateClient(String apiKey) {
        this(OrchestrateClient.builder(apiKey));
    }

    public OrchestrateClient(String apiKey, ObjectMapper objectMapper) {
        this(new Builder(apiKey).mapper(objectMapper));
    }

    public OrchestrateClient(String apiKey, JacksonMapper mapper) {
        this(new Builder(apiKey).mapper(mapper));
    }

    private OrchestrateClient(Builder builder) {
        assert (builder != null);
        this.builder = builder;
        ThreadPoolConfig poolConfig = ThreadPoolConfig.defaultConfig().setPoolName("OrchestrateClientPool").setCorePoolSize(builder.poolSize).setMaxPoolSize(builder.maxPoolSize);
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless().add((Filter)new TransportFilter());
        if (builder.useSSL) {
            SSLEngineConfigurator serverConfig = OrchestrateClient.initializeSSL();
            SSLEngineConfigurator clientConfig = serverConfig.copy().setClientMode(true);
            filterChainBuilder.add((Filter)new SSLFilter(serverConfig, clientConfig));
        }
        filterChainBuilder.add((Filter)new HttpClientFilter()).add((Filter)new ClientFilter(builder.apiKey, builder.host, builder.userAgent));
        this.transport = ((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)TCPNIOTransportBuilder.newInstance().setTcpNoDelay(true).setKeepAlive(true).setWorkerThreadPoolConfig(poolConfig)).setIOStrategy((IOStrategy)WorkerThreadIOStrategy.getInstance())).setProcessor((Processor)filterChainBuilder.build())).build();
    }

    private static SSLEngineConfigurator initializeSSL() {
        SSLContextConfigurator sslContextConfig = new SSLContextConfigurator();
        return new SSLEngineConfigurator(sslContextConfig.createSSLContext(), false, false, false);
    }

    void execute(HttpContent request, ConnectionCompletionHandler handler) {
        assert (request != null);
        assert (handler != null);
        try {
            if (this.transport.isStopped()) {
                this.transport.start();
            }
            InetSocketAddress addr = new InetSocketAddress(this.builder.host.getHost(), this.builder.port);
            this.transport.connect((Object)addr, (CompletionHandler)handler);
        }
        catch (IOException e) {
            handler.failed(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.transport != null && !this.transport.isStopped()) {
            this.transport.shutdownNow();
        }
    }

    @Override
    public OrchestrateRequest<Boolean> deleteCollection(String collection) {
        Preconditions.checkNotNullOrEmpty(collection, "collection");
        String uri = this.uri(collection);
        HttpContent packet = HttpRequestPacket.builder().method(Method.DELETE).uri(uri).query("force=true").build().httpContentBuilder().build();
        return new OrchestrateRequest<Boolean>(this, packet, new ResponseConverter<Boolean>(){

            @Override
            public Boolean from(HttpContent response) throws IOException {
                int status = ((HttpResponsePacket)response.getHttpHeader()).getStatus();
                return status == HttpStatus.NO_CONTENT_204.getStatusCode();
            }
        });
    }

    @Override
    public EventResource event(String collection, String key) {
        Preconditions.checkNotNullOrEmpty(collection, "collection");
        Preconditions.checkNotNullOrEmpty(key, "key");
        return new EventResource(this, this.builder.mapper, collection, key);
    }

    @Override
    public KvResource kv(String collection, String key) {
        Preconditions.checkNotNullOrEmpty(collection, "collection");
        Preconditions.checkNotNullOrEmpty(key, "key");
        return new KvResource(this, this.builder.mapper, collection, key);
    }

    @Override
    public KvListResource listCollection(String collection) {
        Preconditions.checkNotNullOrEmpty(collection, "collection");
        return new KvListResource(this, this.builder.mapper, collection);
    }

    @Override
    public void ping(String collection) throws IOException {
        Preconditions.checkNotNullOrEmpty(collection, "collection");
        try {
            this.listCollection(collection).limit(0).get(String.class).get();
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    @Override
    public RelationResource relation(String collection, String key) {
        Preconditions.checkNotNullOrEmpty(collection, "collection");
        Preconditions.checkNotNullOrEmpty(key, "key");
        return new RelationResource(this, this.builder.mapper, collection, key);
    }

    @Override
    public CollectionSearchResource searchCollection(String collection) {
        Preconditions.checkNotNullOrEmpty(collection, "collection");
        return new CollectionSearchResource(this, this.builder.mapper, collection);
    }

    public static Builder builder(String apiKey) {
        return new Builder(apiKey);
    }

    String uri(String ... segments) {
        int length = 3 + segments.length;
        for (String segment : segments) {
            length += segment.length();
        }
        UEncoder encoder = ENCODER_HOLDER.get();
        StringBuilder buff = new StringBuilder(length).append("/v0");
        for (String segment : segments) {
            buff.append('/').append(encoder.encodeURL(segment));
        }
        return buff.toString();
    }

    String encode(String ... segments) {
        UEncoder encoder = ENCODER_HOLDER.get();
        if (segments.length == 1) {
            return encoder.encodeURL(segments[0]);
        }
        int length = segments.length - 1;
        for (String segment : segments) {
            length += segment.length();
        }
        StringBuilder buff = new StringBuilder(length);
        for (int i = 0; i < segments.length; ++i) {
            if (i != 0) {
                buff.append('/');
            }
            buff.append(encoder.encodeURL(segments[i]));
        }
        return buff.toString();
    }

    public static final class Builder {
        public static final String DEFAULT_HOST = "https://api.orchestrate.io";
        public static final int DEFAULT_PORT = 443;
        private final String apiKey;
        private URI host;
        private int port;
        private int poolSize;
        private int maxPoolSize;
        private JacksonMapper mapper;
        private boolean useSSL;
        private String userAgent;

        private Builder(String apiKey) {
            Preconditions.checkNotNullOrEmpty(apiKey, "apiKey");
            this.apiKey = apiKey;
            this.host(DEFAULT_HOST);
            this.port(443);
            this.poolSize(Runtime.getRuntime().availableProcessors());
            this.maxPoolSize(Integer.MAX_VALUE);
            this.mapper(JacksonMapper.builder());
            this.useSSL(Boolean.TRUE);
        }

        public Builder host(String host) {
            Preconditions.checkNotNullOrEmpty(host, "host");
            this.host = URI.create(host);
            return this;
        }

        public Builder port(int port) {
            Preconditions.checkArgument(port > 0 && port <= 65535, "'port' must be between 1 and 65535.");
            this.port = port;
            return this;
        }

        public Builder poolSize(int poolSize) {
            this.poolSize = Preconditions.checkNotNegative(poolSize, "poolSize");
            return this;
        }

        public Builder maxPoolSize(int maxPoolSize) {
            this.maxPoolSize = Preconditions.checkNotNegative(maxPoolSize, "maxPoolSize");
            return this;
        }

        public Builder mapper(@NonNull ObjectMapper objectMapper) {
            if (objectMapper == null) {
                throw new NullPointerException("objectMapper");
            }
            return this.mapper(JacksonMapper.builder(objectMapper));
        }

        public Builder mapper(@NonNull JacksonMapper.Builder mapperBuilder) {
            if (mapperBuilder == null) {
                throw new NullPointerException("mapperBuilder");
            }
            return this.mapper(mapperBuilder.build());
        }

        public Builder mapper(@NonNull JacksonMapper mapper) {
            if (mapper == null) {
                throw new NullPointerException("mapper");
            }
            this.mapper = mapper;
            return this;
        }

        public Builder useSSL(boolean useSSL) {
            this.useSSL = useSSL;
            return this;
        }

        public Builder userAgent(@NonNull String userAgent) {
            if (userAgent == null) {
                throw new NullPointerException("userAgent");
            }
            this.userAgent = userAgent;
            return this;
        }

        public OrchestrateClient build() {
            return new OrchestrateClient(this);
        }
    }
}

