/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

public class Event<T> {
    private final T value;
    private final String rawValue;
    private final long timestamp;

    Event(T value, String rawValue, long timestamp) {
        assert (value != null);
        assert (rawValue != null);
        assert (timestamp >= 0L);
        this.value = value;
        this.rawValue = rawValue;
        this.timestamp = timestamp;
    }

    public final T getValue() {
        return this.value;
    }

    public final String getRawValue() {
        return this.rawValue;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "Event(value=" + this.getValue() + ", rawValue=" + this.getRawValue() + ", timestamp=" + this.getTimestamp() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$rawValue = this.getRawValue();
        String other$rawValue = other.getRawValue();
        if (this$rawValue == null ? other$rawValue != null : !this$rawValue.equals(other$rawValue)) {
            return false;
        }
        return this.getTimestamp() == other.getTimestamp();
    }

    public boolean canEqual(Object other) {
        return other instanceof Event;
    }

    public int hashCode() {
        int PRIME = 277;
        int result = 1;
        T $value = this.getValue();
        result = result * 277 + ($value == null ? 0 : $value.hashCode());
        String $rawValue = this.getRawValue();
        result = result * 277 + ($rawValue == null ? 0 : $rawValue.hashCode());
        long $timestamp = this.getTimestamp();
        result = result * 277 + (int)($timestamp >>> 32 ^ $timestamp);
        return result;
    }
}

