/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.databind.JsonNode;
import io.orchestrate.client.BaseResource;
import io.orchestrate.client.JacksonMapper;
import io.orchestrate.client.KvObject;
import io.orchestrate.client.OrchestrateClient;
import io.orchestrate.client.OrchestrateRequest;
import io.orchestrate.client.Preconditions;
import io.orchestrate.client.ResponseConverter;
import io.orchestrate.client.Result;
import io.orchestrate.client.SearchResults;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;

public class CollectionSearchResource
extends BaseResource {
    private final String collection;
    private int limit;
    private int offset;

    CollectionSearchResource(OrchestrateClient client, JacksonMapper mapper, String collection) {
        super(client, mapper);
        assert (collection != null);
        assert (collection.length() > 0);
        this.collection = collection;
        this.limit = 10;
        this.offset = 0;
    }

    public <T> OrchestrateRequest<SearchResults<T>> get(final Class<T> clazz, String luceneQuery) {
        Preconditions.checkNotNull(clazz, "clazz");
        Preconditions.checkNotNullOrEmpty(luceneQuery, "luceneQuery");
        String query = "query=".concat(this.client.encode(luceneQuery)).concat("&limit=").concat(this.limit + "").concat("&offset=").concat(this.offset + "");
        HttpContent packet = HttpRequestPacket.builder().method(Method.GET).uri(this.client.uri(this.collection)).query(query).build().httpContentBuilder().build();
        return new OrchestrateRequest<SearchResults<T>>(this.client, packet, new ResponseConverter<SearchResults<T>>(){

            @Override
            public SearchResults<T> from(HttpContent response) throws IOException {
                int status = ((HttpResponsePacket)response.getHttpHeader()).getStatus();
                assert (status == 200);
                JsonNode jsonNode = CollectionSearchResource.this.toJsonNode(response);
                int totalCount = jsonNode.get("total_count").asInt();
                int count = jsonNode.get("count").asInt();
                ArrayList results = new ArrayList(count);
                Iterator iter = jsonNode.get("results").elements();
                while (iter.hasNext()) {
                    JsonNode result = (JsonNode)iter.next();
                    double score = result.get("score").asDouble();
                    KvObject kvObject = CollectionSearchResource.this.toKvObject(result, clazz);
                    results.add(new Result(kvObject, score));
                }
                return new SearchResults(results, totalCount);
            }
        });
    }

    public CollectionSearchResource limit(int limit) {
        this.limit = Preconditions.checkNotNegative(limit, "limit");
        return this;
    }

    public CollectionSearchResource offset(int offset) {
        this.offset = Preconditions.checkNotNegative(offset, "offset");
        return this;
    }
}

