/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import io.orchestrate.client.Result;
import java.util.Iterator;
import java.util.List;

public class SearchResults<T>
implements Iterable<Result<T>> {
    private final List<Result<T>> results;
    private final int totalCount;

    SearchResults(List<Result<T>> results, int totalCount) {
        assert (results != null);
        assert (totalCount >= 0);
        this.results = results;
        this.totalCount = totalCount;
    }

    public final Iterable<Result<T>> getResults() {
        return this.results;
    }

    public final int getCount() {
        return this.results.size();
    }

    public final int getTotalCount() {
        return this.totalCount;
    }

    @Override
    public final Iterator<Result<T>> iterator() {
        return this.results.iterator();
    }

    public String toString() {
        return "SearchResults(results=" + this.getResults() + ", totalCount=" + this.getTotalCount() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchResults)) {
            return false;
        }
        SearchResults other = (SearchResults)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Iterable<Result<T>> this$results = this.getResults();
        Iterable<Result<T>> other$results = other.getResults();
        if (this$results == null ? other$results != null : !this$results.equals(other$results)) {
            return false;
        }
        return this.getTotalCount() == other.getTotalCount();
    }

    public boolean canEqual(Object other) {
        return other instanceof SearchResults;
    }

    public int hashCode() {
        int PRIME = 277;
        int result = 1;
        Iterable<Result<T>> $results = this.getResults();
        result = result * 277 + ($results == null ? 0 : $results.hashCode());
        result = result * 277 + this.getTotalCount();
        return result;
    }
}

