/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.orchestrate.client.KvMetadata;
import io.orchestrate.client.KvObject;
import java.io.IOException;

final class ResponseConverterUtil {
    ResponseConverterUtil() {
    }

    static <T> KvObject<T> jsonToKvObject(ObjectMapper mapper, JsonNode jsonNode, Class<T> clazz) throws IOException {
        assert (mapper != null);
        assert (jsonNode != null);
        assert (clazz != null);
        JsonNode path = jsonNode.get("path");
        String collection = path.get("collection").asText();
        String key = path.get("key").asText();
        String ref = path.get("ref").asText();
        KvMetadata metadata = new KvMetadata(collection, key, ref);
        JsonNode valueNode = jsonNode.get("value");
        String rawValue = mapper.writeValueAsString((Object)valueNode);
        String value = clazz == String.class ? rawValue : valueNode.traverse((ObjectCodec)mapper).readValueAs(clazz);
        return new KvObject<String>(metadata, value, rawValue);
    }
}

