/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import io.orchestrate.client.ClientException;
import io.orchestrate.client.ConnectionCompletionHandler;
import io.orchestrate.client.OrchestrateClient;
import io.orchestrate.client.Preconditions;
import io.orchestrate.client.ResponseCompletionHandler;
import io.orchestrate.client.ResponseConverter;
import io.orchestrate.client.ResponseListener;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.impl.SafeFutureImpl;

public final class OrchestrateRequest<T>
implements Future<T> {
    public static final int DEFAULT_TIMEOUT = 2500;
    private final SafeFutureImpl<HttpContent> rawResponseFuture;
    private final SafeFutureImpl<T> convertedResponseFuture;
    private GrizzlyFuture activeRequest;

    OrchestrateRequest(OrchestrateClient client, HttpContent httpRequest, final ResponseConverter<T> converter) {
        assert (client != null);
        assert (httpRequest != null);
        assert (converter != null);
        this.rawResponseFuture = SafeFutureImpl.create();
        this.convertedResponseFuture = SafeFutureImpl.create();
        this.rawResponseFuture.addCompletionHandler((CompletionHandler)new CompletionHandler<HttpContent>(){

            public void cancelled() {
                OrchestrateRequest.this.convertedResponseFuture.cancel(false);
            }

            public void failed(Throwable throwable) {
                OrchestrateRequest.this.convertedResponseFuture.failure(throwable);
            }

            public void completed(HttpContent result) {
                try {
                    OrchestrateRequest.this.convertedResponseFuture.result(converter.from(result));
                }
                catch (IOException e) {
                    this.failed(e);
                }
            }

            public void updated(HttpContent result) {
            }
        });
        client.execute(httpRequest, new ConnectionCompletionHandler(this, httpRequest));
    }

    public OrchestrateRequest<T> on(@NonNull Iterable<ResponseListener<T>> listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners");
        }
        for (ResponseListener<T> listener : listeners) {
            this.convertedResponseFuture.addCompletionHandler(new ResponseCompletionHandler<T>(listener));
        }
        return this;
    }

    public OrchestrateRequest<T> on(@NonNull ResponseListener<T> listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.convertedResponseFuture.addCompletionHandler(new ResponseCompletionHandler<T>(listener));
        return this;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.activeRequest != null) {
            this.activeRequest.cancel(mayInterruptIfRunning);
        }
        return this.convertedResponseFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.convertedResponseFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.convertedResponseFuture.isDone();
    }

    @Override
    public T get() {
        try {
            return this.get(2500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) {
        Preconditions.checkNotNegative(timeout, "timeout");
        try {
            return (T)this.convertedResponseFuture.get(timeout, unit);
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    void failed(Throwable t) {
        this.convertedResponseFuture.failure(t);
    }

    void setActiveRequest(GrizzlyFuture activeRequest) {
        this.activeRequest = activeRequest;
    }

    SafeFutureImpl<HttpContent> getRawResponseFuture() {
        return this.rawResponseFuture;
    }
}

