/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import io.orchestrate.client.BaseResource;
import io.orchestrate.client.JacksonMapper;
import io.orchestrate.client.KvMetadata;
import io.orchestrate.client.KvObject;
import io.orchestrate.client.OrchestrateClient;
import io.orchestrate.client.OrchestrateRequest;
import io.orchestrate.client.Preconditions;
import io.orchestrate.client.ResponseConverter;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.UEncoder;
import org.glassfish.grizzly.memory.ByteBufferWrapper;

public class KvResource
extends BaseResource {
    private final String collection;
    private final String key;
    private boolean ifAbsent;
    private String objectRef;

    KvResource(OrchestrateClient client, JacksonMapper mapper, String collection, String key) {
        super(client, mapper);
        assert (collection != null);
        assert (collection.length() > 0);
        assert (key != null);
        assert (key.length() > 0);
        this.collection = collection;
        this.key = key;
        this.ifAbsent = false;
        this.objectRef = null;
    }

    public OrchestrateRequest<Boolean> delete() {
        return this.delete(Boolean.FALSE);
    }

    public OrchestrateRequest<Boolean> delete(boolean purge) {
        Preconditions.checkArgument(!this.ifAbsent, "'ifAbsent' cannot be used in a DELETE request.");
        UEncoder urlEncoder = new UEncoder();
        String uri = urlEncoder.encodeURL(this.collection).concat("/").concat(urlEncoder.encodeURL(this.key));
        HttpRequestPacket.Builder builder = HttpRequestPacket.builder().method(Method.DELETE).uri(uri);
        if (purge) {
            builder.query("purge=true");
        }
        if (this.objectRef != null) {
            builder.header(Header.IfMatch, "\"".concat(this.objectRef).concat("\""));
        }
        HttpContent packet = builder.build().httpContentBuilder().build();
        return new OrchestrateRequest<Boolean>(this.client, packet, new ResponseConverter<Boolean>(){

            @Override
            public Boolean from(HttpContent response) throws IOException {
                int status = ((HttpResponsePacket)response.getHttpHeader()).getStatus();
                return status == HttpStatus.NO_CONTENT_204.getStatusCode();
            }
        });
    }

    public <T> OrchestrateRequest<KvObject<T>> get(Class<T> clazz) {
        return this.get(clazz, null);
    }

    public <T> OrchestrateRequest<KvObject<T>> get(final @NonNull Class<T> clazz, @Nullable String ref) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        UEncoder urlEncoder = new UEncoder();
        String uri = urlEncoder.encodeURL(this.collection).concat("/").concat(urlEncoder.encodeURL(this.key));
        if (ref != null) {
            uri = uri.concat("/refs/").concat(ref);
        }
        HttpContent packet = HttpRequestPacket.builder().method(Method.GET).uri(uri).build().httpContentBuilder().build();
        return new OrchestrateRequest<KvObject<T>>(this.client, packet, new ResponseConverter<KvObject<T>>(){

            @Override
            public KvObject<T> from(HttpContent response) throws IOException {
                HttpHeader header = response.getHttpHeader();
                int status = ((HttpResponsePacket)header).getStatus();
                if (status == 404) {
                    return null;
                }
                String json = response.getContent().toStringContent();
                String ref = header.getHeader(Header.ETag).replace("\"", "").replaceFirst("-gzip$", "");
                String value = clazz == String.class ? json : KvResource.this.mapper.readValue(json, clazz);
                return new KvObject<String>(KvResource.this.collection, KvResource.this.key, ref, value, json);
            }
        });
    }

    public KvResource ifAbsent() {
        return this.ifAbsent(Boolean.TRUE);
    }

    public KvResource ifAbsent(boolean ifAbsent) {
        Preconditions.checkArgument(!ifAbsent || this.objectRef == null, "'ifMatch' and 'ifAbsent' cannot be used together.");
        this.ifAbsent = ifAbsent;
        return this;
    }

    public KvResource ifMatch(@NonNull String objectRef) {
        if (objectRef == null) {
            throw new NullPointerException("objectRef");
        }
        Preconditions.checkArgument(!this.ifAbsent, "'ifMatch' and 'ifAbsent' cannot be used together.");
        this.objectRef = objectRef;
        return this;
    }

    public OrchestrateRequest<KvMetadata> put(@NonNull Object value) {
        byte[] content;
        if (value == null) {
            throw new NullPointerException("value");
        }
        try {
            content = value instanceof String ? ((String)value).getBytes("UTF-8") : this.mapper.writeValueAsBytes(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        UEncoder urlEncoder = new UEncoder();
        String uri = urlEncoder.encodeURL(this.collection).concat("/").concat(urlEncoder.encodeURL(this.key));
        HttpRequestPacket.Builder httpHeaderBuilder = ((HttpRequestPacket.Builder)HttpRequestPacket.builder().method(Method.PUT).contentType("application/json")).uri(uri);
        if (this.objectRef != null) {
            httpHeaderBuilder.header(Header.IfMatch, "\"".concat(this.objectRef).concat("\""));
        } else if (this.ifAbsent) {
            httpHeaderBuilder.header(Header.IfNoneMatch, "\"*\"");
        }
        httpHeaderBuilder.contentLength((long)content.length);
        HttpContent packet = httpHeaderBuilder.build().httpContentBuilder().content((Buffer)new ByteBufferWrapper(ByteBuffer.wrap(content))).build();
        return new OrchestrateRequest<KvMetadata>(this.client, packet, new ResponseConverter<KvMetadata>(){

            @Override
            public KvMetadata from(HttpContent response) throws IOException {
                HttpHeader header = response.getHttpHeader();
                int status = ((HttpResponsePacket)header).getStatus();
                if (status == 201) {
                    String ref = header.getHeader(Header.ETag).replace("\"", "").replace("-gzip", "");
                    return new KvMetadata(KvResource.this.collection, KvResource.this.key, ref);
                }
                return null;
            }
        });
    }
}

